/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.KafkaTopicSpec;
import io.strimzi.api.kafka.model.KafkaTopicSpecFluent;
import io.strimzi.api.kafka.model.SpecFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class KafkaTopicSpecFluentImpl<A extends KafkaTopicSpecFluent<A>>
extends SpecFluentImpl<A>
implements KafkaTopicSpecFluent<A> {
    private String topicName;
    private Integer partitions;
    private Integer replicas;
    private Map<String, Object> config;

    public KafkaTopicSpecFluentImpl() {
    }

    public KafkaTopicSpecFluentImpl(KafkaTopicSpec instance) {
        this.withTopicName(instance.getTopicName());
        this.withPartitions(instance.getPartitions());
        this.withReplicas(instance.getReplicas());
        this.withConfig(instance.getConfig());
    }

    @Override
    public String getTopicName() {
        return this.topicName;
    }

    @Override
    public A withTopicName(String topicName) {
        this.topicName = topicName;
        return (A)this;
    }

    @Override
    public Boolean hasTopicName() {
        return this.topicName != null;
    }

    @Override
    @Deprecated
    public A withNewTopicName(String original) {
        return this.withTopicName(new String(original));
    }

    @Override
    public Integer getPartitions() {
        return this.partitions;
    }

    @Override
    public A withPartitions(Integer partitions) {
        this.partitions = partitions;
        return (A)this;
    }

    @Override
    public Boolean hasPartitions() {
        return this.partitions != null;
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    public A addToConfig(String key, Object value) {
        if (this.config == null && key != null && value != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.config.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToConfig(Map<String, Object> map) {
        if (this.config == null && map != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.config.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfig(String key) {
        if (this.config == null) {
            return (A)this;
        }
        if (key != null && this.config != null) {
            this.config.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfig(Map<String, Object> map) {
        if (this.config == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.config == null) continue;
                this.config.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getConfig() {
        return this.config;
    }

    @Override
    public <K, V> A withConfig(Map<String, Object> config) {
        this.config = config == null ? null : new LinkedHashMap<String, Object>(config);
        return (A)this;
    }

    @Override
    public Boolean hasConfig() {
        return this.config != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaTopicSpecFluentImpl that = (KafkaTopicSpecFluentImpl)o;
        if (this.topicName != null ? !this.topicName.equals(that.topicName) : that.topicName != null) {
            return false;
        }
        if (this.partitions != null ? !this.partitions.equals(that.partitions) : that.partitions != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        return !(this.config != null ? !this.config.equals(that.config) : that.config != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.topicName, this.partitions, this.replicas, this.config, super.hashCode());
    }
}

