/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.KafkaSpec;
import io.strimzi.api.kafka.model.KafkaSpecFluent;
import io.strimzi.api.kafka.model.KafkaSpecFluentImpl;
import java.util.Objects;

public class KafkaSpecBuilder
extends KafkaSpecFluentImpl<KafkaSpecBuilder>
implements VisitableBuilder<KafkaSpec, KafkaSpecBuilder> {
    KafkaSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaSpecBuilder() {
        this(true);
    }

    public KafkaSpecBuilder(Boolean validationEnabled) {
        this(new KafkaSpec(), validationEnabled);
    }

    public KafkaSpecBuilder(KafkaSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KafkaSpecBuilder(KafkaSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KafkaSpec(), validationEnabled);
    }

    public KafkaSpecBuilder(KafkaSpecFluent<?> fluent, KafkaSpec instance) {
        this(fluent, instance, true);
    }

    public KafkaSpecBuilder(KafkaSpecFluent<?> fluent, KafkaSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withKafka(instance.getKafka());
        fluent.withZookeeper(instance.getZookeeper());
        fluent.withEntityOperator(instance.getEntityOperator());
        fluent.withClusterCa(instance.getClusterCa());
        fluent.withJmxTrans(instance.getJmxTrans());
        fluent.withKafkaExporter(instance.getKafkaExporter());
        fluent.withCruiseControl(instance.getCruiseControl());
        fluent.withClientsCa(instance.getClientsCa());
        fluent.withMaintenanceTimeWindows(instance.getMaintenanceTimeWindows());
        this.validationEnabled = validationEnabled;
    }

    public KafkaSpecBuilder(KafkaSpec instance) {
        this(instance, (Boolean)true);
    }

    public KafkaSpecBuilder(KafkaSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withKafka(instance.getKafka());
        this.withZookeeper(instance.getZookeeper());
        this.withEntityOperator(instance.getEntityOperator());
        this.withClusterCa(instance.getClusterCa());
        this.withJmxTrans(instance.getJmxTrans());
        this.withKafkaExporter(instance.getKafkaExporter());
        this.withCruiseControl(instance.getCruiseControl());
        this.withClientsCa(instance.getClientsCa());
        this.withMaintenanceTimeWindows(instance.getMaintenanceTimeWindows());
        this.validationEnabled = validationEnabled;
    }

    public KafkaSpec build() {
        KafkaSpec buildable = new KafkaSpec();
        buildable.setKafka(this.fluent.getKafka());
        buildable.setZookeeper(this.fluent.getZookeeper());
        buildable.setEntityOperator(this.fluent.getEntityOperator());
        buildable.setClusterCa(this.fluent.getClusterCa());
        buildable.setJmxTrans(this.fluent.getJmxTrans());
        buildable.setKafkaExporter(this.fluent.getKafkaExporter());
        buildable.setCruiseControl(this.fluent.getCruiseControl());
        buildable.setClientsCa(this.fluent.getClientsCa());
        buildable.setMaintenanceTimeWindows(this.fluent.getMaintenanceTimeWindows());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaSpecBuilder that = (KafkaSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

