/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluentImpl;
import io.strimzi.api.kafka.model.ClientTls;
import io.strimzi.api.kafka.model.ClientTlsBuilder;
import io.strimzi.api.kafka.model.ClientTlsFluentImpl;
import io.strimzi.api.kafka.model.KafkaConnectSpec;
import io.strimzi.api.kafka.model.KafkaConnectSpecFluent;
import io.strimzi.api.kafka.model.Rack;
import io.strimzi.api.kafka.model.RackBuilder;
import io.strimzi.api.kafka.model.RackFluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Builder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256FluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512FluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluentImpl;
import io.strimzi.api.kafka.model.connect.build.Build;
import io.strimzi.api.kafka.model.connect.build.BuildBuilder;
import io.strimzi.api.kafka.model.connect.build.BuildFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class KafkaConnectSpecFluentImpl<A extends KafkaConnectSpecFluent<A>>
extends AbstractKafkaConnectSpecFluentImpl<A>
implements KafkaConnectSpecFluent<A> {
    private Map<String, Object> config;
    private String clientRackInitImage;
    private RackBuilder rack;
    private String bootstrapServers;
    private ClientTlsBuilder tls;
    private VisitableBuilder<? extends KafkaClientAuthentication, ?> authentication;
    private BuildBuilder build;

    public KafkaConnectSpecFluentImpl() {
    }

    public KafkaConnectSpecFluentImpl(KafkaConnectSpec instance) {
        this.withConfig(instance.getConfig());
        this.withClientRackInitImage(instance.getClientRackInitImage());
        this.withRack(instance.getRack());
        this.withBootstrapServers(instance.getBootstrapServers());
        this.withTls(instance.getTls());
        this.withAuthentication(instance.getAuthentication());
        this.withBuild(instance.getBuild());
        this.withLogging(instance.getLogging());
        this.withReplicas(instance.getReplicas());
        this.withVersion(instance.getVersion());
        this.withImage(instance.getImage());
        this.withResources(instance.getResources());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withJmxOptions(instance.getJmxOptions());
        this.withJvmOptions(instance.getJvmOptions());
        this.withMetricsConfig(instance.getMetricsConfig());
        this.withTracing(instance.getTracing());
        this.withTemplate(instance.getTemplate());
        this.withExternalConfiguration(instance.getExternalConfiguration());
    }

    @Override
    public A addToConfig(String key, Object value) {
        if (this.config == null && key != null && value != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.config.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToConfig(Map<String, Object> map) {
        if (this.config == null && map != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.config.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfig(String key) {
        if (this.config == null) {
            return (A)this;
        }
        if (key != null && this.config != null) {
            this.config.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfig(Map<String, Object> map) {
        if (this.config == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.config == null) continue;
                this.config.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getConfig() {
        return this.config;
    }

    @Override
    public <K, V> A withConfig(Map<String, Object> config) {
        this.config = config == null ? null : new LinkedHashMap<String, Object>(config);
        return (A)this;
    }

    @Override
    public Boolean hasConfig() {
        return this.config != null;
    }

    @Override
    public String getClientRackInitImage() {
        return this.clientRackInitImage;
    }

    @Override
    public A withClientRackInitImage(String clientRackInitImage) {
        this.clientRackInitImage = clientRackInitImage;
        return (A)this;
    }

    @Override
    public Boolean hasClientRackInitImage() {
        return this.clientRackInitImage != null;
    }

    @Override
    @Deprecated
    public A withNewClientRackInitImage(String original) {
        return this.withClientRackInitImage(new String(original));
    }

    @Override
    @Deprecated
    public Rack getRack() {
        return this.rack != null ? this.rack.build() : null;
    }

    @Override
    public Rack buildRack() {
        return this.rack != null ? this.rack.build() : null;
    }

    @Override
    public A withRack(Rack rack) {
        this._visitables.get((Object)"rack").remove(this.rack);
        if (rack != null) {
            this.rack = new RackBuilder(rack);
            this._visitables.get((Object)"rack").add(this.rack);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRack() {
        return this.rack != null;
    }

    @Override
    public A withNewRack(String topologyKey) {
        return this.withRack(new Rack(topologyKey));
    }

    @Override
    public KafkaConnectSpecFluent.RackNested<A> withNewRack() {
        return new RackNestedImpl();
    }

    @Override
    public KafkaConnectSpecFluent.RackNested<A> withNewRackLike(Rack item) {
        return new RackNestedImpl(item);
    }

    @Override
    public KafkaConnectSpecFluent.RackNested<A> editRack() {
        return this.withNewRackLike(this.getRack());
    }

    @Override
    public KafkaConnectSpecFluent.RackNested<A> editOrNewRack() {
        return this.withNewRackLike(this.getRack() != null ? this.getRack() : new RackBuilder().build());
    }

    @Override
    public KafkaConnectSpecFluent.RackNested<A> editOrNewRackLike(Rack item) {
        return this.withNewRackLike(this.getRack() != null ? this.getRack() : item);
    }

    @Override
    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    @Override
    public A withBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
        return (A)this;
    }

    @Override
    public Boolean hasBootstrapServers() {
        return this.bootstrapServers != null;
    }

    @Override
    @Deprecated
    public A withNewBootstrapServers(String original) {
        return this.withBootstrapServers(new String(original));
    }

    @Override
    @Deprecated
    public ClientTls getTls() {
        return this.tls != null ? this.tls.build() : null;
    }

    @Override
    public ClientTls buildTls() {
        return this.tls != null ? this.tls.build() : null;
    }

    @Override
    public A withTls(ClientTls tls) {
        this._visitables.get((Object)"tls").remove(this.tls);
        if (tls != null) {
            this.tls = new ClientTlsBuilder(tls);
            this._visitables.get((Object)"tls").add(this.tls);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTls() {
        return this.tls != null;
    }

    @Override
    public KafkaConnectSpecFluent.TlsNested<A> withNewTls() {
        return new TlsNestedImpl();
    }

    @Override
    public KafkaConnectSpecFluent.TlsNested<A> withNewTlsLike(ClientTls item) {
        return new TlsNestedImpl(item);
    }

    @Override
    public KafkaConnectSpecFluent.TlsNested<A> editTls() {
        return this.withNewTlsLike(this.getTls());
    }

    @Override
    public KafkaConnectSpecFluent.TlsNested<A> editOrNewTls() {
        return this.withNewTlsLike(this.getTls() != null ? this.getTls() : new ClientTlsBuilder().build());
    }

    @Override
    public KafkaConnectSpecFluent.TlsNested<A> editOrNewTlsLike(ClientTls item) {
        return this.withNewTlsLike(this.getTls() != null ? this.getTls() : item);
    }

    @Override
    @Deprecated
    public KafkaClientAuthentication getAuthentication() {
        return this.authentication != null ? (KafkaClientAuthentication)this.authentication.build() : null;
    }

    @Override
    public KafkaClientAuthentication buildAuthentication() {
        return this.authentication != null ? (KafkaClientAuthentication)this.authentication.build() : null;
    }

    @Override
    public A withAuthentication(KafkaClientAuthentication authentication) {
        if (authentication instanceof KafkaClientAuthenticationScramSha512) {
            this.authentication = new KafkaClientAuthenticationScramSha512Builder((KafkaClientAuthenticationScramSha512)authentication);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        if (authentication instanceof KafkaClientAuthenticationScramSha256) {
            this.authentication = new KafkaClientAuthenticationScramSha256Builder((KafkaClientAuthenticationScramSha256)authentication);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        if (authentication instanceof KafkaClientAuthenticationPlain) {
            this.authentication = new KafkaClientAuthenticationPlainBuilder((KafkaClientAuthenticationPlain)authentication);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        if (authentication instanceof KafkaClientAuthenticationOAuth) {
            this.authentication = new KafkaClientAuthenticationOAuthBuilder((KafkaClientAuthenticationOAuth)authentication);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        if (authentication instanceof KafkaClientAuthenticationTls) {
            this.authentication = new KafkaClientAuthenticationTlsBuilder((KafkaClientAuthenticationTls)authentication);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAuthentication() {
        return this.authentication != null;
    }

    @Override
    public A withKafkaClientAuthenticationScramSha512(KafkaClientAuthenticationScramSha512 kafkaClientAuthenticationScramSha512) {
        this._visitables.get((Object)"authentication").remove(this.authentication);
        if (kafkaClientAuthenticationScramSha512 != null) {
            this.authentication = new KafkaClientAuthenticationScramSha512Builder(kafkaClientAuthenticationScramSha512);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        return (A)this;
    }

    @Override
    public KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512() {
        return new KafkaClientAuthenticationScramSha512NestedImpl();
    }

    @Override
    public KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512Like(KafkaClientAuthenticationScramSha512 item) {
        return new KafkaClientAuthenticationScramSha512NestedImpl(item);
    }

    @Override
    public A withKafkaClientAuthenticationScramSha256(KafkaClientAuthenticationScramSha256 kafkaClientAuthenticationScramSha256) {
        this._visitables.get((Object)"authentication").remove(this.authentication);
        if (kafkaClientAuthenticationScramSha256 != null) {
            this.authentication = new KafkaClientAuthenticationScramSha256Builder(kafkaClientAuthenticationScramSha256);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        return (A)this;
    }

    @Override
    public KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha256Nested<A> withNewKafkaClientAuthenticationScramSha256() {
        return new KafkaClientAuthenticationScramSha256NestedImpl();
    }

    @Override
    public KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha256Nested<A> withNewKafkaClientAuthenticationScramSha256Like(KafkaClientAuthenticationScramSha256 item) {
        return new KafkaClientAuthenticationScramSha256NestedImpl(item);
    }

    @Override
    public A withKafkaClientAuthenticationPlain(KafkaClientAuthenticationPlain kafkaClientAuthenticationPlain) {
        this._visitables.get((Object)"authentication").remove(this.authentication);
        if (kafkaClientAuthenticationPlain != null) {
            this.authentication = new KafkaClientAuthenticationPlainBuilder(kafkaClientAuthenticationPlain);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        return (A)this;
    }

    @Override
    public KafkaConnectSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlain() {
        return new KafkaClientAuthenticationPlainNestedImpl();
    }

    @Override
    public KafkaConnectSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlainLike(KafkaClientAuthenticationPlain item) {
        return new KafkaClientAuthenticationPlainNestedImpl(item);
    }

    @Override
    public A withKafkaClientAuthenticationOAuth(KafkaClientAuthenticationOAuth kafkaClientAuthenticationOAuth) {
        this._visitables.get((Object)"authentication").remove(this.authentication);
        if (kafkaClientAuthenticationOAuth != null) {
            this.authentication = new KafkaClientAuthenticationOAuthBuilder(kafkaClientAuthenticationOAuth);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        return (A)this;
    }

    @Override
    public KafkaConnectSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuth() {
        return new KafkaClientAuthenticationOAuthNestedImpl();
    }

    @Override
    public KafkaConnectSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuthLike(KafkaClientAuthenticationOAuth item) {
        return new KafkaClientAuthenticationOAuthNestedImpl(item);
    }

    @Override
    public A withKafkaClientAuthenticationTls(KafkaClientAuthenticationTls kafkaClientAuthenticationTls) {
        this._visitables.get((Object)"authentication").remove(this.authentication);
        if (kafkaClientAuthenticationTls != null) {
            this.authentication = new KafkaClientAuthenticationTlsBuilder(kafkaClientAuthenticationTls);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        return (A)this;
    }

    @Override
    public KafkaConnectSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTls() {
        return new KafkaClientAuthenticationTlsNestedImpl();
    }

    @Override
    public KafkaConnectSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTlsLike(KafkaClientAuthenticationTls item) {
        return new KafkaClientAuthenticationTlsNestedImpl(item);
    }

    @Override
    @Deprecated
    public Build getBuild() {
        return this.build != null ? this.build.build() : null;
    }

    @Override
    public Build buildBuild() {
        return this.build != null ? this.build.build() : null;
    }

    @Override
    public A withBuild(Build build) {
        this._visitables.get((Object)"build").remove(this.build);
        if (build != null) {
            this.build = new BuildBuilder(build);
            this._visitables.get((Object)"build").add(this.build);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBuild() {
        return this.build != null;
    }

    @Override
    public KafkaConnectSpecFluent.BuildNested<A> withNewBuild() {
        return new BuildNestedImpl();
    }

    @Override
    public KafkaConnectSpecFluent.BuildNested<A> withNewBuildLike(Build item) {
        return new BuildNestedImpl(item);
    }

    @Override
    public KafkaConnectSpecFluent.BuildNested<A> editBuild() {
        return this.withNewBuildLike(this.getBuild());
    }

    @Override
    public KafkaConnectSpecFluent.BuildNested<A> editOrNewBuild() {
        return this.withNewBuildLike(this.getBuild() != null ? this.getBuild() : new BuildBuilder().build());
    }

    @Override
    public KafkaConnectSpecFluent.BuildNested<A> editOrNewBuildLike(Build item) {
        return this.withNewBuildLike(this.getBuild() != null ? this.getBuild() : item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaConnectSpecFluentImpl that = (KafkaConnectSpecFluentImpl)o;
        if (this.config != null ? !this.config.equals(that.config) : that.config != null) {
            return false;
        }
        if (this.clientRackInitImage != null ? !this.clientRackInitImage.equals(that.clientRackInitImage) : that.clientRackInitImage != null) {
            return false;
        }
        if (this.rack != null ? !this.rack.equals(that.rack) : that.rack != null) {
            return false;
        }
        if (this.bootstrapServers != null ? !this.bootstrapServers.equals(that.bootstrapServers) : that.bootstrapServers != null) {
            return false;
        }
        if (this.tls != null ? !this.tls.equals(that.tls) : that.tls != null) {
            return false;
        }
        if (this.authentication != null ? !this.authentication.equals(that.authentication) : that.authentication != null) {
            return false;
        }
        return !(this.build != null ? !this.build.equals(that.build) : that.build != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.config, this.clientRackInitImage, this.rack, this.bootstrapServers, this.tls, this.authentication, this.build, super.hashCode());
    }

    public class BuildNestedImpl<N>
    extends BuildFluentImpl<KafkaConnectSpecFluent.BuildNested<N>>
    implements KafkaConnectSpecFluent.BuildNested<N>,
    Nested<N> {
        private final BuildBuilder builder;

        BuildNestedImpl(Build item) {
            this.builder = new BuildBuilder(this, item);
        }

        BuildNestedImpl() {
            this.builder = new BuildBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaConnectSpecFluentImpl.this.withBuild(this.builder.build());
        }

        @Override
        public N endBuild() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationTlsNestedImpl<N>
    extends KafkaClientAuthenticationTlsFluentImpl<KafkaConnectSpecFluent.KafkaClientAuthenticationTlsNested<N>>
    implements KafkaConnectSpecFluent.KafkaClientAuthenticationTlsNested<N>,
    Nested<N> {
        private final KafkaClientAuthenticationTlsBuilder builder;

        KafkaClientAuthenticationTlsNestedImpl(KafkaClientAuthenticationTls item) {
            this.builder = new KafkaClientAuthenticationTlsBuilder(this, item);
        }

        KafkaClientAuthenticationTlsNestedImpl() {
            this.builder = new KafkaClientAuthenticationTlsBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaConnectSpecFluentImpl.this.withAuthentication(this.builder.build());
        }

        @Override
        public N endKafkaClientAuthenticationTls() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationOAuthNestedImpl<N>
    extends KafkaClientAuthenticationOAuthFluentImpl<KafkaConnectSpecFluent.KafkaClientAuthenticationOAuthNested<N>>
    implements KafkaConnectSpecFluent.KafkaClientAuthenticationOAuthNested<N>,
    Nested<N> {
        private final KafkaClientAuthenticationOAuthBuilder builder;

        KafkaClientAuthenticationOAuthNestedImpl(KafkaClientAuthenticationOAuth item) {
            this.builder = new KafkaClientAuthenticationOAuthBuilder(this, item);
        }

        KafkaClientAuthenticationOAuthNestedImpl() {
            this.builder = new KafkaClientAuthenticationOAuthBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaConnectSpecFluentImpl.this.withAuthentication(this.builder.build());
        }

        @Override
        public N endKafkaClientAuthenticationOAuth() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationPlainNestedImpl<N>
    extends KafkaClientAuthenticationPlainFluentImpl<KafkaConnectSpecFluent.KafkaClientAuthenticationPlainNested<N>>
    implements KafkaConnectSpecFluent.KafkaClientAuthenticationPlainNested<N>,
    Nested<N> {
        private final KafkaClientAuthenticationPlainBuilder builder;

        KafkaClientAuthenticationPlainNestedImpl(KafkaClientAuthenticationPlain item) {
            this.builder = new KafkaClientAuthenticationPlainBuilder(this, item);
        }

        KafkaClientAuthenticationPlainNestedImpl() {
            this.builder = new KafkaClientAuthenticationPlainBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaConnectSpecFluentImpl.this.withAuthentication(this.builder.build());
        }

        @Override
        public N endKafkaClientAuthenticationPlain() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationScramSha256NestedImpl<N>
    extends KafkaClientAuthenticationScramSha256FluentImpl<KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha256Nested<N>>
    implements KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha256Nested<N>,
    Nested<N> {
        private final KafkaClientAuthenticationScramSha256Builder builder;

        KafkaClientAuthenticationScramSha256NestedImpl(KafkaClientAuthenticationScramSha256 item) {
            this.builder = new KafkaClientAuthenticationScramSha256Builder(this, item);
        }

        KafkaClientAuthenticationScramSha256NestedImpl() {
            this.builder = new KafkaClientAuthenticationScramSha256Builder(this);
        }

        @Override
        public N and() {
            return (N)KafkaConnectSpecFluentImpl.this.withAuthentication(this.builder.build());
        }

        @Override
        public N endKafkaClientAuthenticationScramSha256() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationScramSha512NestedImpl<N>
    extends KafkaClientAuthenticationScramSha512FluentImpl<KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha512Nested<N>>
    implements KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha512Nested<N>,
    Nested<N> {
        private final KafkaClientAuthenticationScramSha512Builder builder;

        KafkaClientAuthenticationScramSha512NestedImpl(KafkaClientAuthenticationScramSha512 item) {
            this.builder = new KafkaClientAuthenticationScramSha512Builder(this, item);
        }

        KafkaClientAuthenticationScramSha512NestedImpl() {
            this.builder = new KafkaClientAuthenticationScramSha512Builder(this);
        }

        @Override
        public N and() {
            return (N)KafkaConnectSpecFluentImpl.this.withAuthentication(this.builder.build());
        }

        @Override
        public N endKafkaClientAuthenticationScramSha512() {
            return this.and();
        }
    }

    public class TlsNestedImpl<N>
    extends ClientTlsFluentImpl<KafkaConnectSpecFluent.TlsNested<N>>
    implements KafkaConnectSpecFluent.TlsNested<N>,
    Nested<N> {
        private final ClientTlsBuilder builder;

        TlsNestedImpl(ClientTls item) {
            this.builder = new ClientTlsBuilder(this, item);
        }

        TlsNestedImpl() {
            this.builder = new ClientTlsBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaConnectSpecFluentImpl.this.withTls(this.builder.build());
        }

        @Override
        public N endTls() {
            return this.and();
        }
    }

    public class RackNestedImpl<N>
    extends RackFluentImpl<KafkaConnectSpecFluent.RackNested<N>>
    implements KafkaConnectSpecFluent.RackNested<N>,
    Nested<N> {
        private final RackBuilder builder;

        RackNestedImpl(Rack item) {
            this.builder = new RackBuilder(this, item);
        }

        RackNestedImpl() {
            this.builder = new RackBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaConnectSpecFluentImpl.this.withRack(this.builder.build());
        }

        @Override
        public N endRack() {
            return this.and();
        }
    }
}

