/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.CruiseControlSpec;
import io.strimzi.api.kafka.model.CruiseControlSpecFluent;
import io.strimzi.api.kafka.model.ExternalLogging;
import io.strimzi.api.kafka.model.ExternalLoggingBuilder;
import io.strimzi.api.kafka.model.ExternalLoggingFluentImpl;
import io.strimzi.api.kafka.model.InlineLogging;
import io.strimzi.api.kafka.model.InlineLoggingBuilder;
import io.strimzi.api.kafka.model.InlineLoggingFluentImpl;
import io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics;
import io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder;
import io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsFluentImpl;
import io.strimzi.api.kafka.model.JvmOptions;
import io.strimzi.api.kafka.model.JvmOptionsBuilder;
import io.strimzi.api.kafka.model.JvmOptionsFluentImpl;
import io.strimzi.api.kafka.model.Logging;
import io.strimzi.api.kafka.model.MetricsConfig;
import io.strimzi.api.kafka.model.Probe;
import io.strimzi.api.kafka.model.ProbeBuilder;
import io.strimzi.api.kafka.model.ProbeFluentImpl;
import io.strimzi.api.kafka.model.TlsSidecar;
import io.strimzi.api.kafka.model.TlsSidecarBuilder;
import io.strimzi.api.kafka.model.TlsSidecarFluentImpl;
import io.strimzi.api.kafka.model.balancing.BrokerCapacity;
import io.strimzi.api.kafka.model.balancing.BrokerCapacityBuilder;
import io.strimzi.api.kafka.model.balancing.BrokerCapacityFluentImpl;
import io.strimzi.api.kafka.model.template.CruiseControlTemplate;
import io.strimzi.api.kafka.model.template.CruiseControlTemplateBuilder;
import io.strimzi.api.kafka.model.template.CruiseControlTemplateFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class CruiseControlSpecFluentImpl<A extends CruiseControlSpecFluent<A>>
extends BaseFluent<A>
implements CruiseControlSpecFluent<A> {
    private String image;
    private TlsSidecarBuilder tlsSidecar;
    private ResourceRequirements resources;
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;
    private JvmOptionsBuilder jvmOptions;
    private VisitableBuilder<? extends Logging, ?> logging;
    private CruiseControlTemplateBuilder template;
    private BrokerCapacityBuilder brokerCapacity;
    private Map<String, Object> config;
    private VisitableBuilder<? extends MetricsConfig, ?> metricsConfig;

    public CruiseControlSpecFluentImpl() {
    }

    public CruiseControlSpecFluentImpl(CruiseControlSpec instance) {
        this.withImage(instance.getImage());
        this.withTlsSidecar(instance.getTlsSidecar());
        this.withResources(instance.getResources());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withJvmOptions(instance.getJvmOptions());
        this.withLogging(instance.getLogging());
        this.withTemplate(instance.getTemplate());
        this.withBrokerCapacity(instance.getBrokerCapacity());
        this.withConfig(instance.getConfig());
        this.withMetricsConfig(instance.getMetricsConfig());
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    @Deprecated
    public A withNewImage(String original) {
        return this.withImage(new String(original));
    }

    @Override
    @Deprecated
    public TlsSidecar getTlsSidecar() {
        return this.tlsSidecar != null ? this.tlsSidecar.build() : null;
    }

    @Override
    public TlsSidecar buildTlsSidecar() {
        return this.tlsSidecar != null ? this.tlsSidecar.build() : null;
    }

    @Override
    public A withTlsSidecar(TlsSidecar tlsSidecar) {
        this._visitables.get((Object)"tlsSidecar").remove(this.tlsSidecar);
        if (tlsSidecar != null) {
            this.tlsSidecar = new TlsSidecarBuilder(tlsSidecar);
            this._visitables.get((Object)"tlsSidecar").add(this.tlsSidecar);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTlsSidecar() {
        return this.tlsSidecar != null;
    }

    @Override
    public CruiseControlSpecFluent.TlsSidecarNested<A> withNewTlsSidecar() {
        return new TlsSidecarNestedImpl();
    }

    @Override
    public CruiseControlSpecFluent.TlsSidecarNested<A> withNewTlsSidecarLike(TlsSidecar item) {
        return new TlsSidecarNestedImpl(item);
    }

    @Override
    public CruiseControlSpecFluent.TlsSidecarNested<A> editTlsSidecar() {
        return this.withNewTlsSidecarLike(this.getTlsSidecar());
    }

    @Override
    public CruiseControlSpecFluent.TlsSidecarNested<A> editOrNewTlsSidecar() {
        return this.withNewTlsSidecarLike(this.getTlsSidecar() != null ? this.getTlsSidecar() : new TlsSidecarBuilder().build());
    }

    @Override
    public CruiseControlSpecFluent.TlsSidecarNested<A> editOrNewTlsSidecarLike(TlsSidecar item) {
        return this.withNewTlsSidecarLike(this.getTlsSidecar() != null ? this.getTlsSidecar() : item);
    }

    @Override
    public ResourceRequirements getResources() {
        return this.resources;
    }

    @Override
    public A withResources(ResourceRequirements resources) {
        this.resources = resources;
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    @Deprecated
    public Probe getLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public A withLivenessProbe(Probe livenessProbe) {
        this._visitables.get((Object)"livenessProbe").remove(this.livenessProbe);
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.get((Object)"livenessProbe").add(this.livenessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    @Override
    public A withNewLivenessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    @Override
    public CruiseControlSpecFluent.LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNestedImpl();
    }

    @Override
    public CruiseControlSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNestedImpl(item);
    }

    @Override
    public CruiseControlSpecFluent.LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe());
    }

    @Override
    public CruiseControlSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : new ProbeBuilder().build());
    }

    @Override
    public CruiseControlSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : item);
    }

    @Override
    @Deprecated
    public Probe getReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public A withReadinessProbe(Probe readinessProbe) {
        this._visitables.get((Object)"readinessProbe").remove(this.readinessProbe);
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.get((Object)"readinessProbe").add(this.readinessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    @Override
    public A withNewReadinessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    @Override
    public CruiseControlSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNestedImpl();
    }

    @Override
    public CruiseControlSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNestedImpl(item);
    }

    @Override
    public CruiseControlSpecFluent.ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe());
    }

    @Override
    public CruiseControlSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : new ProbeBuilder().build());
    }

    @Override
    public CruiseControlSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : item);
    }

    @Override
    @Deprecated
    public JvmOptions getJvmOptions() {
        return this.jvmOptions != null ? this.jvmOptions.build() : null;
    }

    @Override
    public JvmOptions buildJvmOptions() {
        return this.jvmOptions != null ? this.jvmOptions.build() : null;
    }

    @Override
    public A withJvmOptions(JvmOptions jvmOptions) {
        this._visitables.get((Object)"jvmOptions").remove(this.jvmOptions);
        if (jvmOptions != null) {
            this.jvmOptions = new JvmOptionsBuilder(jvmOptions);
            this._visitables.get((Object)"jvmOptions").add(this.jvmOptions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasJvmOptions() {
        return this.jvmOptions != null;
    }

    @Override
    public CruiseControlSpecFluent.JvmOptionsNested<A> withNewJvmOptions() {
        return new JvmOptionsNestedImpl();
    }

    @Override
    public CruiseControlSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item) {
        return new JvmOptionsNestedImpl(item);
    }

    @Override
    public CruiseControlSpecFluent.JvmOptionsNested<A> editJvmOptions() {
        return this.withNewJvmOptionsLike(this.getJvmOptions());
    }

    @Override
    public CruiseControlSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions() {
        return this.withNewJvmOptionsLike(this.getJvmOptions() != null ? this.getJvmOptions() : new JvmOptionsBuilder().build());
    }

    @Override
    public CruiseControlSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item) {
        return this.withNewJvmOptionsLike(this.getJvmOptions() != null ? this.getJvmOptions() : item);
    }

    @Override
    @Deprecated
    public Logging getLogging() {
        return this.logging != null ? (Logging)this.logging.build() : null;
    }

    @Override
    public Logging buildLogging() {
        return this.logging != null ? (Logging)this.logging.build() : null;
    }

    @Override
    public A withLogging(Logging logging) {
        if (logging instanceof ExternalLogging) {
            this.logging = new ExternalLoggingBuilder((ExternalLogging)logging);
            this._visitables.get((Object)"logging").add(this.logging);
        }
        if (logging instanceof InlineLogging) {
            this.logging = new InlineLoggingBuilder((InlineLogging)logging);
            this._visitables.get((Object)"logging").add(this.logging);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLogging() {
        return this.logging != null;
    }

    @Override
    public A withExternalLogging(ExternalLogging externalLogging) {
        this._visitables.get((Object)"logging").remove(this.logging);
        if (externalLogging != null) {
            this.logging = new ExternalLoggingBuilder(externalLogging);
            this._visitables.get((Object)"logging").add(this.logging);
        }
        return (A)this;
    }

    @Override
    public CruiseControlSpecFluent.ExternalLoggingNested<A> withNewExternalLogging() {
        return new ExternalLoggingNestedImpl();
    }

    @Override
    public CruiseControlSpecFluent.ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item) {
        return new ExternalLoggingNestedImpl(item);
    }

    @Override
    public A withInlineLogging(InlineLogging inlineLogging) {
        this._visitables.get((Object)"logging").remove(this.logging);
        if (inlineLogging != null) {
            this.logging = new InlineLoggingBuilder(inlineLogging);
            this._visitables.get((Object)"logging").add(this.logging);
        }
        return (A)this;
    }

    @Override
    public CruiseControlSpecFluent.InlineLoggingNested<A> withNewInlineLogging() {
        return new InlineLoggingNestedImpl();
    }

    @Override
    public CruiseControlSpecFluent.InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item) {
        return new InlineLoggingNestedImpl(item);
    }

    @Override
    @Deprecated
    public CruiseControlTemplate getTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public CruiseControlTemplate buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public A withTemplate(CruiseControlTemplate template) {
        this._visitables.get((Object)"template").remove(this.template);
        if (template != null) {
            this.template = new CruiseControlTemplateBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplate() {
        return this.template != null;
    }

    @Override
    public CruiseControlSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public CruiseControlSpecFluent.TemplateNested<A> withNewTemplateLike(CruiseControlTemplate item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public CruiseControlSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public CruiseControlSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new CruiseControlTemplateBuilder().build());
    }

    @Override
    public CruiseControlSpecFluent.TemplateNested<A> editOrNewTemplateLike(CruiseControlTemplate item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    @Override
    @Deprecated
    public BrokerCapacity getBrokerCapacity() {
        return this.brokerCapacity != null ? this.brokerCapacity.build() : null;
    }

    @Override
    public BrokerCapacity buildBrokerCapacity() {
        return this.brokerCapacity != null ? this.brokerCapacity.build() : null;
    }

    @Override
    public A withBrokerCapacity(BrokerCapacity brokerCapacity) {
        this._visitables.get((Object)"brokerCapacity").remove(this.brokerCapacity);
        if (brokerCapacity != null) {
            this.brokerCapacity = new BrokerCapacityBuilder(brokerCapacity);
            this._visitables.get((Object)"brokerCapacity").add(this.brokerCapacity);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBrokerCapacity() {
        return this.brokerCapacity != null;
    }

    @Override
    public CruiseControlSpecFluent.BrokerCapacityNested<A> withNewBrokerCapacity() {
        return new BrokerCapacityNestedImpl();
    }

    @Override
    public CruiseControlSpecFluent.BrokerCapacityNested<A> withNewBrokerCapacityLike(BrokerCapacity item) {
        return new BrokerCapacityNestedImpl(item);
    }

    @Override
    public CruiseControlSpecFluent.BrokerCapacityNested<A> editBrokerCapacity() {
        return this.withNewBrokerCapacityLike(this.getBrokerCapacity());
    }

    @Override
    public CruiseControlSpecFluent.BrokerCapacityNested<A> editOrNewBrokerCapacity() {
        return this.withNewBrokerCapacityLike(this.getBrokerCapacity() != null ? this.getBrokerCapacity() : new BrokerCapacityBuilder().build());
    }

    @Override
    public CruiseControlSpecFluent.BrokerCapacityNested<A> editOrNewBrokerCapacityLike(BrokerCapacity item) {
        return this.withNewBrokerCapacityLike(this.getBrokerCapacity() != null ? this.getBrokerCapacity() : item);
    }

    @Override
    public A addToConfig(String key, Object value) {
        if (this.config == null && key != null && value != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.config.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToConfig(Map<String, Object> map) {
        if (this.config == null && map != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.config.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfig(String key) {
        if (this.config == null) {
            return (A)this;
        }
        if (key != null && this.config != null) {
            this.config.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfig(Map<String, Object> map) {
        if (this.config == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.config == null) continue;
                this.config.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getConfig() {
        return this.config;
    }

    @Override
    public <K, V> A withConfig(Map<String, Object> config) {
        this.config = config == null ? null : new LinkedHashMap<String, Object>(config);
        return (A)this;
    }

    @Override
    public Boolean hasConfig() {
        return this.config != null;
    }

    @Override
    @Deprecated
    public MetricsConfig getMetricsConfig() {
        return this.metricsConfig != null ? (MetricsConfig)this.metricsConfig.build() : null;
    }

    @Override
    public MetricsConfig buildMetricsConfig() {
        return this.metricsConfig != null ? (MetricsConfig)this.metricsConfig.build() : null;
    }

    @Override
    public A withMetricsConfig(MetricsConfig metricsConfig) {
        if (metricsConfig instanceof JmxPrometheusExporterMetrics) {
            this.metricsConfig = new JmxPrometheusExporterMetricsBuilder((JmxPrometheusExporterMetrics)metricsConfig);
            this._visitables.get((Object)"metricsConfig").add(this.metricsConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetricsConfig() {
        return this.metricsConfig != null;
    }

    @Override
    public A withJmxPrometheusExporterMetricsConfig(JmxPrometheusExporterMetrics jmxPrometheusExporterMetricsConfig) {
        this._visitables.get((Object)"metricsConfig").remove(this.metricsConfig);
        if (jmxPrometheusExporterMetricsConfig != null) {
            this.metricsConfig = new JmxPrometheusExporterMetricsBuilder(jmxPrometheusExporterMetricsConfig);
            this._visitables.get((Object)"metricsConfig").add(this.metricsConfig);
        }
        return (A)this;
    }

    @Override
    public CruiseControlSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfig() {
        return new JmxPrometheusExporterMetricsConfigNestedImpl();
    }

    @Override
    public CruiseControlSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfigLike(JmxPrometheusExporterMetrics item) {
        return new JmxPrometheusExporterMetricsConfigNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CruiseControlSpecFluentImpl that = (CruiseControlSpecFluentImpl)o;
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.tlsSidecar != null ? !this.tlsSidecar.equals(that.tlsSidecar) : that.tlsSidecar != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals((Object)that.resources) : that.resources != null) {
            return false;
        }
        if (this.livenessProbe != null ? !this.livenessProbe.equals(that.livenessProbe) : that.livenessProbe != null) {
            return false;
        }
        if (this.readinessProbe != null ? !this.readinessProbe.equals(that.readinessProbe) : that.readinessProbe != null) {
            return false;
        }
        if (this.jvmOptions != null ? !this.jvmOptions.equals(that.jvmOptions) : that.jvmOptions != null) {
            return false;
        }
        if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) {
            return false;
        }
        if (this.template != null ? !this.template.equals(that.template) : that.template != null) {
            return false;
        }
        if (this.brokerCapacity != null ? !this.brokerCapacity.equals(that.brokerCapacity) : that.brokerCapacity != null) {
            return false;
        }
        if (this.config != null ? !this.config.equals(that.config) : that.config != null) {
            return false;
        }
        return !(this.metricsConfig != null ? !this.metricsConfig.equals(that.metricsConfig) : that.metricsConfig != null);
    }

    public int hashCode() {
        return Objects.hash(this.image, this.tlsSidecar, this.resources, this.livenessProbe, this.readinessProbe, this.jvmOptions, this.logging, this.template, this.brokerCapacity, this.config, this.metricsConfig, super.hashCode());
    }

    public class JmxPrometheusExporterMetricsConfigNestedImpl<N>
    extends JmxPrometheusExporterMetricsFluentImpl<CruiseControlSpecFluent.JmxPrometheusExporterMetricsConfigNested<N>>
    implements CruiseControlSpecFluent.JmxPrometheusExporterMetricsConfigNested<N>,
    Nested<N> {
        private final JmxPrometheusExporterMetricsBuilder builder;

        JmxPrometheusExporterMetricsConfigNestedImpl(JmxPrometheusExporterMetrics item) {
            this.builder = new JmxPrometheusExporterMetricsBuilder(this, item);
        }

        JmxPrometheusExporterMetricsConfigNestedImpl() {
            this.builder = new JmxPrometheusExporterMetricsBuilder(this);
        }

        @Override
        public N and() {
            return (N)CruiseControlSpecFluentImpl.this.withMetricsConfig(this.builder.build());
        }

        @Override
        public N endJmxPrometheusExporterMetricsConfig() {
            return this.and();
        }
    }

    public class BrokerCapacityNestedImpl<N>
    extends BrokerCapacityFluentImpl<CruiseControlSpecFluent.BrokerCapacityNested<N>>
    implements CruiseControlSpecFluent.BrokerCapacityNested<N>,
    Nested<N> {
        private final BrokerCapacityBuilder builder;

        BrokerCapacityNestedImpl(BrokerCapacity item) {
            this.builder = new BrokerCapacityBuilder(this, item);
        }

        BrokerCapacityNestedImpl() {
            this.builder = new BrokerCapacityBuilder(this);
        }

        @Override
        public N and() {
            return (N)CruiseControlSpecFluentImpl.this.withBrokerCapacity(this.builder.build());
        }

        @Override
        public N endBrokerCapacity() {
            return this.and();
        }
    }

    public class TemplateNestedImpl<N>
    extends CruiseControlTemplateFluentImpl<CruiseControlSpecFluent.TemplateNested<N>>
    implements CruiseControlSpecFluent.TemplateNested<N>,
    Nested<N> {
        private final CruiseControlTemplateBuilder builder;

        TemplateNestedImpl(CruiseControlTemplate item) {
            this.builder = new CruiseControlTemplateBuilder(this, item);
        }

        TemplateNestedImpl() {
            this.builder = new CruiseControlTemplateBuilder(this);
        }

        @Override
        public N and() {
            return (N)CruiseControlSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }

    public class InlineLoggingNestedImpl<N>
    extends InlineLoggingFluentImpl<CruiseControlSpecFluent.InlineLoggingNested<N>>
    implements CruiseControlSpecFluent.InlineLoggingNested<N>,
    Nested<N> {
        private final InlineLoggingBuilder builder;

        InlineLoggingNestedImpl(InlineLogging item) {
            this.builder = new InlineLoggingBuilder(this, item);
        }

        InlineLoggingNestedImpl() {
            this.builder = new InlineLoggingBuilder(this);
        }

        @Override
        public N and() {
            return (N)CruiseControlSpecFluentImpl.this.withLogging(this.builder.build());
        }

        @Override
        public N endInlineLogging() {
            return this.and();
        }
    }

    public class ExternalLoggingNestedImpl<N>
    extends ExternalLoggingFluentImpl<CruiseControlSpecFluent.ExternalLoggingNested<N>>
    implements CruiseControlSpecFluent.ExternalLoggingNested<N>,
    Nested<N> {
        private final ExternalLoggingBuilder builder;

        ExternalLoggingNestedImpl(ExternalLogging item) {
            this.builder = new ExternalLoggingBuilder(this, item);
        }

        ExternalLoggingNestedImpl() {
            this.builder = new ExternalLoggingBuilder(this);
        }

        @Override
        public N and() {
            return (N)CruiseControlSpecFluentImpl.this.withLogging(this.builder.build());
        }

        @Override
        public N endExternalLogging() {
            return this.and();
        }
    }

    public class JvmOptionsNestedImpl<N>
    extends JvmOptionsFluentImpl<CruiseControlSpecFluent.JvmOptionsNested<N>>
    implements CruiseControlSpecFluent.JvmOptionsNested<N>,
    Nested<N> {
        private final JvmOptionsBuilder builder;

        JvmOptionsNestedImpl(JvmOptions item) {
            this.builder = new JvmOptionsBuilder(this, item);
        }

        JvmOptionsNestedImpl() {
            this.builder = new JvmOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)CruiseControlSpecFluentImpl.this.withJvmOptions(this.builder.build());
        }

        @Override
        public N endJvmOptions() {
            return this.and();
        }
    }

    public class ReadinessProbeNestedImpl<N>
    extends ProbeFluentImpl<CruiseControlSpecFluent.ReadinessProbeNested<N>>
    implements CruiseControlSpecFluent.ReadinessProbeNested<N>,
    Nested<N> {
        private final ProbeBuilder builder;

        ReadinessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        ReadinessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)CruiseControlSpecFluentImpl.this.withReadinessProbe(this.builder.build());
        }

        @Override
        public N endReadinessProbe() {
            return this.and();
        }
    }

    public class LivenessProbeNestedImpl<N>
    extends ProbeFluentImpl<CruiseControlSpecFluent.LivenessProbeNested<N>>
    implements CruiseControlSpecFluent.LivenessProbeNested<N>,
    Nested<N> {
        private final ProbeBuilder builder;

        LivenessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        LivenessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)CruiseControlSpecFluentImpl.this.withLivenessProbe(this.builder.build());
        }

        @Override
        public N endLivenessProbe() {
            return this.and();
        }
    }

    public class TlsSidecarNestedImpl<N>
    extends TlsSidecarFluentImpl<CruiseControlSpecFluent.TlsSidecarNested<N>>
    implements CruiseControlSpecFluent.TlsSidecarNested<N>,
    Nested<N> {
        private final TlsSidecarBuilder builder;

        TlsSidecarNestedImpl(TlsSidecar item) {
            this.builder = new TlsSidecarBuilder(this, item);
        }

        TlsSidecarNestedImpl() {
            this.builder = new TlsSidecarBuilder(this);
        }

        @Override
        public N and() {
            return (N)CruiseControlSpecFluentImpl.this.withTlsSidecar(this.builder.build());
        }

        @Override
        public N endTlsSidecar() {
            return this.and();
        }
    }
}

