/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.CertSecretSource;
import io.strimzi.api.kafka.model.CertSecretSourceFluent;
import io.strimzi.api.kafka.model.CertSecretSourceFluentImpl;
import java.util.Objects;

public class CertSecretSourceBuilder
extends CertSecretSourceFluentImpl<CertSecretSourceBuilder>
implements VisitableBuilder<CertSecretSource, CertSecretSourceBuilder> {
    CertSecretSourceFluent<?> fluent;
    Boolean validationEnabled;

    public CertSecretSourceBuilder() {
        this(true);
    }

    public CertSecretSourceBuilder(Boolean validationEnabled) {
        this(new CertSecretSource(), validationEnabled);
    }

    public CertSecretSourceBuilder(CertSecretSourceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CertSecretSourceBuilder(CertSecretSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CertSecretSource(), validationEnabled);
    }

    public CertSecretSourceBuilder(CertSecretSourceFluent<?> fluent, CertSecretSource instance) {
        this(fluent, instance, true);
    }

    public CertSecretSourceBuilder(CertSecretSourceFluent<?> fluent, CertSecretSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withSecretName(instance.getSecretName());
        fluent.withCertificate(instance.getCertificate());
        this.validationEnabled = validationEnabled;
    }

    public CertSecretSourceBuilder(CertSecretSource instance) {
        this(instance, (Boolean)true);
    }

    public CertSecretSourceBuilder(CertSecretSource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withSecretName(instance.getSecretName());
        this.withCertificate(instance.getCertificate());
        this.validationEnabled = validationEnabled;
    }

    public CertSecretSource build() {
        CertSecretSource buildable = new CertSecretSource();
        buildable.setSecretName(this.fluent.getSecretName());
        buildable.setCertificate(this.fluent.getCertificate());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CertSecretSourceBuilder that = (CertSecretSourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

