/*
 * Decompiled with CFR 0.152.
 */
package org.openx.data.jsonserde.objectinspector.primitive;

import java.math.BigDecimal;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableFloatObjectInspector;
import org.apache.hadoop.io.FloatWritable;
import org.openx.data.jsonserde.objectinspector.primitive.TypeEntryShim;

public class JavaStringFloatObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements SettableFloatObjectInspector {
    public JavaStringFloatObjectInspector() {
        super(TypeEntryShim.floatType);
    }

    public Object getPrimitiveWritableObject(Object o) {
        if (o == null) {
            return null;
        }
        return new FloatWritable(this.get(o));
    }

    public float get(Object o) {
        if (o instanceof Integer) {
            return ((Integer)o).floatValue();
        }
        if (o instanceof Long) {
            return ((Long)o).floatValue();
        }
        if (o instanceof Double) {
            return ((Double)o).floatValue();
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).floatValue();
        }
        return Float.parseFloat(o.toString());
    }

    public Object getPrimitiveJavaObject(Object o) {
        return Float.valueOf(this.get(o));
    }

    public Object create(float value) {
        return Float.valueOf(value);
    }

    public Object set(Object o, float value) {
        return Float.valueOf(value);
    }
}

