/*
 * Decompiled with CFR 0.152.
 */
package org.openx.data.jsonserde.objectinspector.primitive;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;

public class JavaStringDecimalObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements SettableHiveDecimalObjectInspector {
    public JavaStringDecimalObjectInspector(DecimalTypeInfo typeInfo) {
        super((PrimitiveTypeInfo)typeInfo);
    }

    public HiveDecimalWritable getPrimitiveWritableObject(Object o) {
        HiveDecimal dec = this.get(o);
        return dec == null ? null : new HiveDecimalWritable(dec);
    }

    private HiveDecimal get(Object o) {
        if (o == null) {
            return null;
        }
        return this.enforcePrecisionScale(this.getHiveDecimal(o));
    }

    private HiveDecimal getHiveDecimal(Object o) {
        if (o instanceof Integer) {
            return HiveDecimal.create((int)((Integer)o));
        }
        if (o instanceof Long) {
            return HiveDecimal.create((long)((Long)o));
        }
        if (o instanceof Double) {
            return HiveDecimal.create((double)((Double)o));
        }
        if (o instanceof BigDecimal) {
            return HiveDecimal.create((BigDecimal)((BigDecimal)o));
        }
        return HiveDecimal.create((String)o.toString());
    }

    public HiveDecimal getPrimitiveJavaObject(Object o) {
        return this.get(o);
    }

    public Object set(Object o, byte[] bytes, int scale) {
        return this.enforcePrecisionScale(HiveDecimal.create((BigInteger)new BigInteger(bytes), (int)scale));
    }

    public Object set(Object o, HiveDecimal t) {
        return this.enforcePrecisionScale(t);
    }

    public Object set(Object o, HiveDecimalWritable t) {
        return t == null ? null : this.enforcePrecisionScale(t.getHiveDecimal());
    }

    public Object create(byte[] bytes, int scale) {
        return HiveDecimal.create((BigInteger)new BigInteger(bytes), (int)scale);
    }

    public Object create(HiveDecimal t) {
        return t;
    }

    private HiveDecimal enforcePrecisionScale(HiveDecimal dec) {
        return HiveDecimalUtils.enforcePrecisionScale((HiveDecimal)dec, (DecimalTypeInfo)((DecimalTypeInfo)this.typeInfo));
    }
}

