/*
 * Decompiled with CFR 0.152.
 */
package org.openx.data.jsonserde.objectinspector;

import io.starburst.openjson.JSONArray;
import io.starburst.openjson.JSONException;
import io.starburst.openjson.JSONObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.openx.data.jsonserde.objectinspector.JsonObjectInspectorUtils;
import org.openx.data.jsonserde.objectinspector.JsonStructOIOptions;
import org.openx.data.jsonserde.objectinspector.primitive.JsonStringJavaObjectInspector;

public class JsonStructObjectInspector
extends StandardStructObjectInspector {
    JsonStructOIOptions options = null;
    List<Object> values = new ArrayList<Object>();

    public JsonStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, JsonStructOIOptions opts) {
        super(structFieldNames, structFieldObjectInspectors);
        this.options = opts;
    }

    public Object getStructFieldData(Object data, StructField fieldRef) {
        if (JsonObjectInspectorUtils.checkObject(data) == null) {
            return null;
        }
        if (data instanceof JSONObject) {
            return this.getStructFieldDataFromJsonObject((JSONObject)data, fieldRef);
        }
        if (data instanceof List) {
            return this.getStructFieldDataFromList((List)data, fieldRef);
        }
        if (data instanceof JSONArray) {
            JSONArray ja = (JSONArray)data;
            if (ja.length() == 0) {
                return null;
            }
            return this.getStructFieldDataFromJsonArray(ja, fieldRef);
        }
        throw new Error("Data is not JSONObject  but " + data.getClass().getCanonicalName() + " with value " + data.toString());
    }

    public Object getStructFieldDataFromList(List data, StructField fieldRef) {
        int idx = this.fields.indexOf(fieldRef);
        if (idx < 0 || idx >= data.size()) {
            return null;
        }
        return data.get(idx);
    }

    public Object getStructFieldDataFromJsonArray(JSONArray data, StructField fieldRef) {
        int idx = this.fields.indexOf(fieldRef);
        try {
            return data.get(idx);
        }
        catch (JSONException ex) {
            return null;
        }
    }

    public Object getStructFieldDataFromJsonObject(JSONObject data, StructField fieldRef) {
        Object fieldData;
        int fieldID;
        block8: {
            if (JsonObjectInspectorUtils.checkObject(data) == null) {
                return null;
            }
            StandardStructObjectInspector.MyField f = (StandardStructObjectInspector.MyField)fieldRef;
            fieldID = f.getFieldID();
            assert (fieldID >= 0 && fieldID < this.fields.size());
            fieldData = null;
            try {
                String s;
                if (data.has(this.getJsonField(fieldRef))) {
                    fieldData = data.get(this.getJsonField(fieldRef));
                    break block8;
                }
                if (!this.options.dotsInKeyNames) break block8;
                Iterator i = data.keys();
                while (i.hasNext() && (s = (String)i.next()) != null) {
                    if (!s.contains(".")) continue;
                    String name = s.replaceAll("\\.", "_");
                    if (!fieldRef.getFieldName().equals(name)) continue;
                    fieldData = data.get(s);
                    break;
                }
            }
            catch (JSONException i) {
                // empty catch block
            }
        }
        if (fieldData == JSONObject.NULL) {
            fieldData = null;
        }
        if ((fieldData instanceof JSONObject || fieldData instanceof JSONArray) && ((StandardStructObjectInspector.MyField)this.fields.get(fieldID)).getFieldObjectInspector() instanceof JsonStringJavaObjectInspector) {
            JsonStringJavaObjectInspector fieldInspector = (JsonStringJavaObjectInspector)((StandardStructObjectInspector.MyField)this.fields.get(fieldID)).getFieldObjectInspector();
            return fieldInspector.getPrimitiveJavaObject(fieldData);
        }
        return fieldData;
    }

    protected String getJsonField(StructField fr) {
        if (this.options.getMappings() != null && this.options.getMappings().containsKey(fr.getFieldName())) {
            return this.options.getMappings().get(fr.getFieldName());
        }
        return fr.getFieldName();
    }

    public List<Object> getStructFieldsDataAsList(Object o) {
        if (JsonObjectInspectorUtils.checkObject(o) == null) {
            return null;
        }
        JSONObject jObj = (JSONObject)o;
        this.values.clear();
        for (int i = 0; i < this.fields.size(); ++i) {
            if (jObj.has(this.getJsonField((StructField)this.fields.get(i)))) {
                this.values.add(this.getStructFieldData(o, (StructField)this.fields.get(i)));
                continue;
            }
            this.values.add(null);
        }
        return this.values;
    }
}

