/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import io.swagger.models.ModelImpl;
import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.util.List;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.AllowableValues;

public class EnumMapper {
    static ModelImpl maybeAddEnumValues(ModelImpl toReturn, AllowableValues allowableValues) {
        if (allowableValues instanceof AllowableListValues) {
            toReturn.setEnum(((AllowableListValues)allowableValues).getValues());
        }
        return toReturn;
    }

    static SerializableParameter maybeAddEnumValues(SerializableParameter toReturn, AllowableValues allowableValues) {
        if (allowableValues instanceof AllowableListValues) {
            toReturn.setEnum(((AllowableListValues)allowableValues).getValues());
        }
        return toReturn;
    }

    static Property maybeAddEnumValues(Property property, AllowableValues allowableValues) {
        if (allowableValues instanceof AllowableListValues) {
            if (property instanceof StringProperty) {
                StringProperty stringProperty = (StringProperty)property;
                AllowableListValues listValues = (AllowableListValues)allowableValues;
                stringProperty.setEnum(listValues.getValues());
            } else if (property instanceof IntegerProperty) {
                IntegerProperty integerProperty = (IntegerProperty)property;
                AllowableListValues listValues = (AllowableListValues)allowableValues;
                integerProperty.setEnum(EnumMapper.convert(listValues.getValues(), Integer.class));
            } else if (property instanceof LongProperty) {
                LongProperty longProperty = (LongProperty)property;
                AllowableListValues listValues = (AllowableListValues)allowableValues;
                longProperty.setEnum(EnumMapper.convert(listValues.getValues(), Long.class));
            }
        }
        return property;
    }

    private static <T extends Number> List<T> convert(List<String> values, Class<T> toType) {
        return Lists.newArrayList((Iterable)Optional.presentInstances((Iterable)FluentIterable.from(values).transform(EnumMapper.converterOfType(toType))));
    }

    private static <T extends Number> Function<? super String, Optional<T>> converterOfType(final Class<T> toType) {
        return new Function<String, Optional<T>>(){

            public Optional<T> apply(String input) {
                try {
                    if (Integer.class.equals((Object)toType)) {
                        return Optional.of((Object)new Integer(input));
                    }
                    if (Long.class.equals((Object)toType)) {
                        return Optional.of((Object)new Long(input));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return Optional.absent();
            }
        };
    }
}

