/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import io.swagger.models.ModelImpl;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.mapstruct.Mapper;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.AllowableRangeValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.service.ApiListing;
import springfox.documentation.swagger2.mappers.Properties;

@Mapper
public abstract class ModelMapper {
    public Map<String, io.swagger.models.Model> mapModels(Map<String, Model> from) {
        if (from == null) {
            return null;
        }
        HashMap<String, io.swagger.models.Model> map = new HashMap<String, io.swagger.models.Model>();
        for (Map.Entry<String, Model> entry : from.entrySet()) {
            String key = entry.getKey();
            io.swagger.models.Model value = this.mapProperties(entry.getValue());
            map.put(key, value);
        }
        return map;
    }

    public io.swagger.models.Model mapProperties(Model source) {
        ModelImpl model = new ModelImpl().description(source.getDescription()).discriminator(source.getDiscriminator()).example((Object)"").name(source.getName());
        TreeMap sorted = Maps.newTreeMap();
        sorted.putAll(this.mapProperties(source.getProperties()));
        model.setProperties((Map)sorted);
        FluentIterable requiredFields = FluentIterable.from(source.getProperties().values()).filter(this.requiredProperty()).transform(this.propertyName());
        model.setRequired((List)requiredFields.toList());
        model.setSimple(false);
        if (springfox.documentation.schema.Maps.isMapType((ResolvedType)source.getType())) {
            Optional<Class> clazz = this.typeOfValue(source);
            if (clazz.isPresent()) {
                model.additionalProperties(Properties.property(((Class)clazz.get()).getSimpleName()));
            } else {
                model.additionalProperties((Property)new ObjectProperty());
            }
        }
        return model;
    }

    private Optional<Class> typeOfValue(Model source) {
        if (source.getType().getTypeParameters() != null && source.getType().getTypeParameters().size() > 0) {
            return Optional.of((Object)((ResolvedType)source.getType().getTypeParameters().get(1)).getErasedType());
        }
        return Optional.absent();
    }

    public Property mapProperty(ModelProperty source) {
        AllowableValues allowableValues;
        Property property = ModelMapper.modelRefToProperty(source.getModelRef());
        if (property instanceof StringProperty && (allowableValues = source.getAllowableValues()) instanceof AllowableListValues) {
            ((StringProperty)property).setEnum(((AllowableListValues)allowableValues).getValues());
        }
        if (property instanceof AbstractNumericProperty && (allowableValues = source.getAllowableValues()) instanceof AllowableRangeValues) {
            AllowableRangeValues range = (AllowableRangeValues)allowableValues;
            ((AbstractNumericProperty)property).maximum(Double.valueOf(range.getMax()));
            ((AbstractNumericProperty)property).minimum(Double.valueOf(range.getMin()));
        }
        if (property != null) {
            property.setDescription(source.getDescription());
            property.setName(source.getName());
            property.setRequired(source.isRequired().booleanValue());
        }
        return property;
    }

    static Property modelRefToProperty(ModelRef modelRef) {
        Property responseProperty;
        if (modelRef == null || "void".equalsIgnoreCase(modelRef.getType())) {
            return null;
        }
        if (modelRef.isCollection()) {
            String itemType = modelRef.getItemType();
            responseProperty = new ArrayProperty(Properties.property(itemType));
        } else if (modelRef.isMap()) {
            String itemType = modelRef.getItemType();
            responseProperty = new MapProperty(Properties.property(itemType));
        } else {
            responseProperty = Properties.property(modelRef.getType());
        }
        return responseProperty;
    }

    protected Map<String, io.swagger.models.Model> modelsFromApiListings(Multimap<String, ApiListing> apiListings) {
        HashMap definitions = Maps.newHashMap();
        for (ApiListing each : apiListings.values()) {
            definitions.putAll(each.getModels());
        }
        return this.mapModels(definitions);
    }

    protected abstract Map<String, Property> mapProperties(Map<String, ModelProperty> var1);

    private Function<ModelProperty, String> propertyName() {
        return new Function<ModelProperty, String>(){

            public String apply(ModelProperty input) {
                return input.getName();
            }
        };
    }

    private Predicate<ModelProperty> requiredProperty() {
        return new Predicate<ModelProperty>(){

            public boolean apply(ModelProperty input) {
                return input.isRequired();
            }
        };
    }
}

