/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.readers.parameter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.wordnik.swagger.annotations.ApiParam;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;
import springfox.documentation.swagger.readers.parameter.ParameterAnnotationReader;

@Component(value="swagger2ParameterNameReader")
@Order(value=-2147482648)
public class ParameterNameReader
implements ParameterBuilderPlugin {
    private ParameterAnnotationReader annotations = new ParameterAnnotationReader();

    public void apply(ParameterContext context) {
        MethodParameter methodParameter = context.methodParameter();
        Optional<ApiParam> apiParam = this.apiParam(methodParameter);
        if (apiParam.isPresent()) {
            context.parameterBuilder().name(Strings.emptyToNull((String)((ApiParam)apiParam.get()).name()));
        }
    }

    @VisibleForTesting
    Optional<ApiParam> apiParam(MethodParameter methodParameter) {
        return Optional.fromNullable((Object)methodParameter.getParameterAnnotation(ApiParam.class)).or(this.annotations.fromHierarchy(methodParameter, ApiParam.class));
    }

    public boolean supports(DocumentationType delimiter) {
        return DocumentationType.SWAGGER_2.equals((Object)delimiter);
    }
}

