/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.parameter;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiParam;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.core.MethodParameter;

public class ParameterAnnotationReader {
    public static Optional<ApiParam> apiParam(MethodParameter methodParameter) {
        return Optional.fromNullable((Object)methodParameter.getParameterAnnotation(ApiParam.class)).or(ParameterAnnotationReader.fromHierarchy(methodParameter, ApiParam.class));
    }

    public static <A extends Annotation> Optional<A> fromHierarchy(MethodParameter methodParameter, Class<A> annotationType) {
        return Optional.fromNullable(ParameterAnnotationReader.searchOnInterfaces(methodParameter.getMethod(), methodParameter.getParameterIndex(), annotationType, ParameterAnnotationReader.getParentInterfaces(methodParameter)));
    }

    private static <A extends Annotation> Predicate<? super Annotation> annotationOfType(final Class<A> annotationType) {
        return new Predicate<Annotation>(){

            public boolean apply(Annotation input) {
                return input.annotationType().equals(annotationType);
            }
        };
    }

    private static Optional<Method> interfaceMethod(Class<?> iface, Method method) {
        try {
            return Optional.of((Object)iface.getMethod(method.getName(), method.getParameterTypes()));
        }
        catch (NoSuchMethodException ex) {
            return Optional.absent();
        }
    }

    private static <A extends Annotation> A searchOnInterfaces(Method method, int parameterIndex, Class<A> annotationType, Class<?>[] interfaces) {
        Annotation annotation = null;
        for (Class<?> interfaze : interfaces) {
            Optional<Method> interfaceMethod = ParameterAnnotationReader.interfaceMethod(interfaze, method);
            if (!interfaceMethod.isPresent()) continue;
            Method superMethod = (Method)interfaceMethod.get();
            Optional found = Iterables.tryFind((Iterable)Lists.newArrayList((Object[])superMethod.getParameterAnnotations()[parameterIndex]), ParameterAnnotationReader.annotationOfType(annotationType));
            if (found.isPresent()) {
                annotation = (Annotation)found.get();
                break;
            }
            Class<?>[] superInterfaces = superMethod.getDeclaringClass().getInterfaces();
            annotation = ParameterAnnotationReader.searchOnInterfaces(superMethod, parameterIndex, annotationType, superInterfaces);
        }
        return (A)annotation;
    }

    private static Class<?>[] getParentInterfaces(MethodParameter methodParameter) {
        return methodParameter.getMethod().getDeclaringClass().getInterfaces();
    }
}

