/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.ClassSupport;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;

@Component
public class InMemorySwaggerResourcesProvider
implements SwaggerResourcesProvider {
    private final String swagger1Url;
    private final String swagger2Url;
    private boolean swagger1Available;
    private boolean swagger2Available;
    private final DocumentationCache documentationCache;

    @Autowired
    public InMemorySwaggerResourcesProvider(Environment environment, DocumentationCache documentationCache) {
        this.swagger1Url = environment.getProperty("springfox.documentation.swagger.v1.path", "/api-docs");
        this.swagger2Url = environment.getProperty("springfox.documentation.swagger.v2.path", "/v2/api-docs");
        this.swagger1Available = ClassSupport.classByName((String)"springfox.documentation.swagger1.web.Swagger1Controller").isPresent();
        this.swagger2Available = ClassSupport.classByName((String)"springfox.documentation.swagger2.web.Swagger2ControllerWebFlux").isPresent() || ClassSupport.classByName((String)"springfox.documentation.swagger2.web.Swagger2ControllerWebMvc").isPresent();
        this.documentationCache = documentationCache;
    }

    @Override
    public List<SwaggerResource> get() {
        ArrayList<SwaggerResource> resources = new ArrayList<SwaggerResource>();
        for (Map.Entry entry : this.documentationCache.all().entrySet()) {
            SwaggerResource swaggerResource;
            String swaggerGroup = (String)entry.getKey();
            if (this.swagger1Available) {
                swaggerResource = this.resource(swaggerGroup, this.swagger1Url);
                swaggerResource.setSwaggerVersion("1.2");
                resources.add(swaggerResource);
            }
            if (!this.swagger2Available) continue;
            swaggerResource = this.resource(swaggerGroup, this.swagger2Url);
            swaggerResource.setSwaggerVersion("2.0");
            resources.add(swaggerResource);
        }
        Collections.sort(resources);
        return resources;
    }

    private SwaggerResource resource(String swaggerGroup, String baseUrl) {
        SwaggerResource swaggerResource = new SwaggerResource();
        swaggerResource.setName(swaggerGroup);
        swaggerResource.setUrl(this.swaggerLocation(baseUrl, swaggerGroup));
        return swaggerResource;
    }

    private String swaggerLocation(String swaggerUrl, String swaggerGroup) {
        String base = Optional.of(swaggerUrl).get();
        if ("default".equals(swaggerGroup)) {
            return base;
        }
        return base + "?group=" + swaggerGroup;
    }
}

