/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web;

import com.fasterxml.classmate.ResolvedType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.RequestHandler;
import springfox.documentation.RequestHandlerKey;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spring.web.ControllerNamingUtils;
import springfox.documentation.spring.web.WebMvcNameValueExpressionWrapper;
import springfox.documentation.spring.web.WebMvcPatternsRequestConditionWrapper;
import springfox.documentation.spring.web.WebMvcRequestMappingInfoWrapper;
import springfox.documentation.spring.web.readers.operation.HandlerMethodResolver;
import springfox.documentation.spring.wrapper.NameValueExpression;
import springfox.documentation.spring.wrapper.PatternsRequestCondition;
import springfox.documentation.spring.wrapper.RequestMappingInfo;

public class WebMvcRequestHandler
implements RequestHandler {
    private final String contextPath;
    private final HandlerMethodResolver methodResolver;
    private final org.springframework.web.servlet.mvc.method.RequestMappingInfo requestMapping;
    private final HandlerMethod handlerMethod;

    public WebMvcRequestHandler(String contextPath, HandlerMethodResolver methodResolver, org.springframework.web.servlet.mvc.method.RequestMappingInfo requestMapping, HandlerMethod handlerMethod) {
        this.contextPath = contextPath;
        this.methodResolver = methodResolver;
        this.requestMapping = requestMapping;
        this.handlerMethod = handlerMethod;
    }

    public HandlerMethod getHandlerMethod() {
        return this.handlerMethod;
    }

    public RequestHandler combine(RequestHandler other) {
        return this;
    }

    public Class<?> declaringClass() {
        return this.handlerMethod.getBeanType();
    }

    public boolean isAnnotatedWith(Class<? extends Annotation> annotation) {
        return null != AnnotationUtils.findAnnotation((Method)this.handlerMethod.getMethod(), annotation);
    }

    public PatternsRequestCondition getPatternsCondition() {
        return new WebMvcPatternsRequestConditionWrapper(this.contextPath, this.requestMapping.getPatternsCondition());
    }

    public String groupName() {
        return ControllerNamingUtils.controllerNameAsGroup((HandlerMethod)this.handlerMethod);
    }

    public String getName() {
        return this.handlerMethod.getMethod().getName();
    }

    public Set<RequestMethod> supportedMethods() {
        return this.requestMapping.getMethodsCondition().getMethods();
    }

    public Set<? extends MediaType> produces() {
        return this.requestMapping.getProducesCondition().getProducibleMediaTypes();
    }

    public Set<? extends MediaType> consumes() {
        return this.requestMapping.getConsumesCondition().getConsumableMediaTypes();
    }

    public Set<NameValueExpression<String>> headers() {
        return WebMvcNameValueExpressionWrapper.from(this.requestMapping.getHeadersCondition().getExpressions());
    }

    public Set<NameValueExpression<String>> params() {
        return WebMvcNameValueExpressionWrapper.from(this.requestMapping.getParamsCondition().getExpressions());
    }

    public <T extends Annotation> Optional<T> findAnnotation(Class<T> annotation) {
        return Optional.ofNullable(AnnotationUtils.findAnnotation((Method)this.handlerMethod.getMethod(), annotation));
    }

    public RequestHandlerKey key() {
        return new RequestHandlerKey(this.requestMapping.getPatternsCondition().getPatterns(), this.requestMapping.getMethodsCondition().getMethods(), this.requestMapping.getConsumesCondition().getConsumableMediaTypes(), this.requestMapping.getProducesCondition().getProducibleMediaTypes());
    }

    public RequestMappingInfo getRequestMapping() {
        return new WebMvcRequestMappingInfoWrapper(this.requestMapping);
    }

    public List<ResolvedMethodParameter> getParameters() {
        return this.methodResolver.methodParameters(this.handlerMethod);
    }

    public ResolvedType getReturnType() {
        return this.methodResolver.methodReturnType(this.handlerMethod);
    }

    public <T extends Annotation> Optional<T> findControllerAnnotation(Class<T> annotation) {
        return Optional.ofNullable(AnnotationUtils.findAnnotation((Class)this.handlerMethod.getBeanType(), annotation));
    }

    public String toString() {
        return new StringJoiner(", ", WebMvcRequestHandler.class.getSimpleName() + "{", "}").add("requestMapping=" + this.requestMapping).add("handlerMethod=" + this.handlerMethod).add("key=" + this.key()).toString();
    }
}

