/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.plugins;

import com.fasterxml.classmate.TypeResolver;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import springfox.documentation.PathProvider;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.schema.AlternateTypeRuleConvention;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.DocumentationPlugin;
import springfox.documentation.spi.service.RequestHandlerCombiner;
import springfox.documentation.spi.service.RequestHandlerProvider;
import springfox.documentation.spi.service.contexts.Defaults;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.DocumentationContextBuilder;
import springfox.documentation.spi.service.contexts.Orderings;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.plugins.DefaultConfiguration;
import springfox.documentation.spring.web.plugins.DefaultRequestHandlerCombiner;
import springfox.documentation.spring.web.plugins.DocumentationPluginsBootstrapper;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;
import springfox.documentation.spring.web.scanners.ApiDocumentationScanner;

public class AbstractDocumentationPluginsBootstrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentationPluginsBootstrapper.class);
    private final DocumentationPluginsManager documentationPluginsManager;
    private final List<RequestHandlerProvider> handlerProviders;
    private final ApiDocumentationScanner resourceListing;
    private final DefaultConfiguration defaultConfiguration;
    private final DocumentationCache scanned;
    private RequestHandlerCombiner combiner;
    private List<AlternateTypeRuleConvention> typeConventions;

    public AbstractDocumentationPluginsBootstrapper(DocumentationPluginsManager documentationPluginsManager, List<RequestHandlerProvider> handlerProviders, DocumentationCache scanned, ApiDocumentationScanner resourceListing, Defaults defaults, TypeResolver typeResolver, PathProvider pathProvider) {
        this.documentationPluginsManager = documentationPluginsManager;
        this.handlerProviders = handlerProviders;
        this.scanned = scanned;
        this.resourceListing = resourceListing;
        this.defaultConfiguration = new DefaultConfiguration(defaults, typeResolver, pathProvider);
    }

    protected void bootstrapDocumentationPlugins() {
        List plugins = StreamSupport.stream(this.documentationPluginsManager.documentationPlugins().spliterator(), false).sorted(Orderings.pluginOrdering()).collect(Collectors.toList());
        LOGGER.info("Found {} custom documentation plugin(s)", (Object)plugins.size());
        for (DocumentationPlugin each : plugins) {
            DocumentationType documentationType = each.getDocumentationType();
            if (each.isEnabled()) {
                this.scanDocumentation(this.buildContext(each));
                continue;
            }
            LOGGER.info("Skipping initializing disabled plugin bean {} v{}", (Object)documentationType.getName(), (Object)documentationType.getVersion());
        }
    }

    protected DocumentationContext buildContext(DocumentationPlugin each) {
        return each.configure(this.defaultContextBuilder(each));
    }

    protected void scanDocumentation(DocumentationContext context) {
        try {
            this.getScanned().addDocumentation(this.resourceListing.scan(context));
        }
        catch (Exception e) {
            LOGGER.error(String.format("Unable to scan documentation context %s", context.getGroupName()), (Throwable)e);
        }
    }

    private DocumentationContextBuilder defaultContextBuilder(DocumentationPlugin plugin) {
        DocumentationType documentationType = plugin.getDocumentationType();
        List requestHandlers = this.handlerProviders.stream().map(this.handlers()).flatMap(handle -> StreamSupport.stream(handle.spliterator(), false)).collect(Collectors.toList());
        List rules = BuilderDefaults.nullToEmptyList(this.typeConventions).stream().map(AlternateTypeRuleConvention::rules).flatMap(rule -> StreamSupport.stream(rule.spliterator(), false)).collect(Collectors.toList());
        return this.documentationPluginsManager.createContextBuilder(documentationType, this.defaultConfiguration).rules(rules).requestHandlers(this.combiner().combine(requestHandlers));
    }

    private RequestHandlerCombiner combiner() {
        return Optional.ofNullable(this.combiner).orElse(new DefaultRequestHandlerCombiner());
    }

    private Function<RequestHandlerProvider, ? extends Iterable<RequestHandler>> handlers() {
        return RequestHandlerProvider::requestHandlers;
    }

    public void setCombiner(RequestHandlerCombiner combiner) {
        this.combiner = combiner;
    }

    public void setTypeConventions(List<AlternateTypeRuleConvention> typeConventions) {
        this.typeConventions = typeConventions;
    }

    public DocumentationPluginsManager getDocumentationPluginsManager() {
        return this.documentationPluginsManager;
    }

    public List<RequestHandlerProvider> getHandlerProviders() {
        return this.handlerProviders;
    }

    public ApiDocumentationScanner getResourceListing() {
        return this.resourceListing;
    }

    public DefaultConfiguration getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    public DocumentationCache getScanned() {
        return this.scanned;
    }

    public RequestHandlerCombiner getCombiner() {
        return this.combiner;
    }

    public List<AlternateTypeRuleConvention> getTypeConventions() {
        return this.typeConventions;
    }
}

