/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import springfox.documentation.PathProvider;
import springfox.documentation.builders.ApiListingBuilder;
import springfox.documentation.schema.Model;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.ResourceGroup;
import springfox.documentation.spi.service.contexts.ApiListingContext;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.RequestMappingContext;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;
import springfox.documentation.spring.web.scanners.ApiDescriptionReader;
import springfox.documentation.spring.web.scanners.ApiListingScanningContext;
import springfox.documentation.spring.web.scanners.ApiModelReader;
import springfox.documentation.spring.web.scanners.PathMappingAdjuster;

@Component
public class ApiListingScanner {
    private final ApiDescriptionReader apiDescriptionReader;
    private final ApiModelReader apiModelReader;
    private final DocumentationPluginsManager pluginsManager;

    @Autowired
    public ApiListingScanner(ApiDescriptionReader apiDescriptionReader, ApiModelReader apiModelReader, DocumentationPluginsManager pluginsManager) {
        this.apiDescriptionReader = apiDescriptionReader;
        this.apiModelReader = apiModelReader;
        this.pluginsManager = pluginsManager;
    }

    public Multimap<String, ApiListing> scan(ApiListingScanningContext context) {
        LinkedListMultimap apiListingMap = LinkedListMultimap.create();
        int position = 0;
        Map<ResourceGroup, List<RequestMappingContext>> requestMappingsByResourceGroup = context.getRequestMappingsByResourceGroup();
        ArrayList securityReferences = Lists.newArrayList();
        for (Map.Entry<ResourceGroup, List<RequestMappingContext>> entry : requestMappingsByResourceGroup.entrySet()) {
            ResourceGroup resourceGroup = entry.getKey();
            DocumentationContext documentationContext = context.getDocumentationContext();
            LinkedHashSet produces = new LinkedHashSet(documentationContext.getProduces());
            LinkedHashSet consumes = new LinkedHashSet(documentationContext.getConsumes());
            LinkedHashSet protocols = new LinkedHashSet(documentationContext.getProtocols());
            HashSet apiDescriptions = Sets.newHashSet();
            LinkedHashMap<String, Model> models = new LinkedHashMap<String, Model>();
            for (RequestMappingContext each : entry.getValue()) {
                models.putAll(this.apiModelReader.read(each.withKnownModels(models)));
                apiDescriptions.addAll(this.apiDescriptionReader.read(each));
            }
            ArrayList sortedApis = Lists.newArrayList((Iterable)apiDescriptions);
            Collections.sort(sortedApis, documentationContext.getApiDescriptionOrdering());
            String resourcePath = ApiListingScanner.longestCommonPath(sortedApis);
            PathProvider pathProvider = documentationContext.getPathProvider();
            String basePath = pathProvider.getApplicationBasePath();
            PathMappingAdjuster adjuster = new PathMappingAdjuster(documentationContext);
            ApiListingBuilder apiListingBuilder = new ApiListingBuilder(context.apiDescriptionOrdering()).apiVersion(documentationContext.getApiInfo().getVersion()).basePath(adjuster.adjustedPath(basePath)).resourcePath(resourcePath).produces(produces).consumes(consumes).protocols(protocols).securityReferences((List)securityReferences).apis((List)sortedApis).models(models).description(null).position(position++);
            ApiListingContext apiListingContext = new ApiListingContext(context.getDocumentationType(), resourceGroup, apiListingBuilder);
            apiListingMap.put((Object)resourceGroup.getGroupName(), (Object)this.pluginsManager.apiListing(apiListingContext));
        }
        return apiListingMap;
    }

    static String longestCommonPath(List<ApiDescription> apiDescriptions) {
        ArrayList commons = Lists.newArrayList();
        if (null == apiDescriptions || apiDescriptions.isEmpty()) {
            return null;
        }
        List<String> firstWords = ApiListingScanner.urlParts(apiDescriptions.get(0));
        for (int position = 0; position < firstWords.size(); ++position) {
            String word = firstWords.get(position);
            boolean allContain = true;
            for (int i = 1; i < apiDescriptions.size(); ++i) {
                List<String> words = ApiListingScanner.urlParts(apiDescriptions.get(i));
                if (words.size() >= position + 1 && words.get(position).equals(word)) continue;
                allContain = false;
                break;
            }
            if (!allContain) continue;
            commons.add(word);
        }
        Joiner joiner = Joiner.on((String)"/").skipNulls();
        return "/" + joiner.join((Iterable)commons);
    }

    static List<String> urlParts(ApiDescription apiDescription) {
        return Splitter.on((char)'/').omitEmptyStrings().trimResults().splitToList((CharSequence)apiDescription.getPath());
    }
}

