/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spi.service.contexts;

import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import java.util.Comparator;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.ApiListingReference;
import springfox.documentation.service.Operation;

public class Orderings {
    private Orderings() {
        throw new UnsupportedOperationException();
    }

    public static Comparator<Operation> nickNameComparator() {
        return new Comparator<Operation>(){

            @Override
            public int compare(Operation first, Operation second) {
                return Strings.nullToEmpty((String)first.getUniqueId()).compareTo(Strings.nullToEmpty((String)second.getUniqueId()));
            }
        };
    }

    public static Comparator<Operation> positionComparator() {
        return new Comparator<Operation>(){

            @Override
            public int compare(Operation first, Operation second) {
                return Ints.compare((int)first.getPosition(), (int)second.getPosition());
            }
        };
    }

    public static Comparator<ApiListingReference> listingReferencePathComparator() {
        return new Comparator<ApiListingReference>(){

            @Override
            public int compare(ApiListingReference first, ApiListingReference second) {
                return first.getPath().compareTo(second.getPath());
            }
        };
    }

    public static Comparator<ApiListingReference> listingPositionComparator() {
        return new Comparator<ApiListingReference>(){

            @Override
            public int compare(ApiListingReference first, ApiListingReference second) {
                return Ints.compare((int)first.getPosition(), (int)second.getPosition());
            }
        };
    }

    public static Comparator<ApiDescription> apiPathCompatator() {
        return new Comparator<ApiDescription>(){

            @Override
            public int compare(ApiDescription first, ApiDescription second) {
                return first.getPath().compareTo(second.getPath());
            }
        };
    }
}

