/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.property;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import java.lang.reflect.Type;
import java.util.Optional;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.property.ModelProperty;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.schema.AlternateTypeProvider;

public abstract class BaseModelProperty
implements ModelProperty {
    private final String name;
    private final BeanPropertyDefinition jacksonProperty;
    private final Optional<JsonFormat> jsonFormatAnnotation;
    private final TypeResolver resolver;
    private final AlternateTypeProvider alternateTypeProvider;

    public BaseModelProperty(String name, TypeResolver resolver, AlternateTypeProvider alternateTypeProvider, BeanPropertyDefinition jacksonProperty) {
        this.name = name;
        this.resolver = resolver;
        this.alternateTypeProvider = alternateTypeProvider;
        this.jacksonProperty = jacksonProperty;
        AnnotatedMember primaryMember = jacksonProperty.getPrimaryMember();
        this.jsonFormatAnnotation = primaryMember != null ? Optional.ofNullable(primaryMember.getAnnotation(JsonFormat.class)) : Optional.empty();
    }

    protected abstract ResolvedType realType();

    @Override
    public ResolvedType getType() {
        if (this.jsonFormatAnnotation.isPresent() && this.jsonFormatAnnotation.get().shape() == JsonFormat.Shape.STRING) {
            return this.resolver.resolve(String.class, new Type[0]);
        }
        return this.alternateTypeProvider.alternateFor(this.realType());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String qualifiedTypeName() {
        if (this.getType().getTypeParameters().size() > 0) {
            return this.getType().toString();
        }
        return ResolvedTypes.simpleQualifiedTypeName(this.getType());
    }

    @Override
    public AllowableValues allowableValues() {
        Optional<AllowableValues> allowableValues = Optional.ofNullable(ResolvedTypes.allowableValues(this.getType()));
        return allowableValues.orElse(null);
    }

    @Override
    public boolean isRequired() {
        return this.jacksonProperty.isRequired();
    }

    @Override
    public boolean isReadOnly() {
        return !this.jacksonProperty.hasSetter();
    }

    @Override
    public String propertyDescription() {
        return null;
    }

    @Override
    public int position() {
        return 0;
    }

    public TypeResolver getResolver() {
        return this.resolver;
    }

    public AlternateTypeProvider getAlternateTypeProvider() {
        return this.alternateTypeProvider;
    }

    public String example() {
        if (this.jsonFormatAnnotation.isPresent() && this.jsonFormatAnnotation.get().shape() == JsonFormat.Shape.STRING) {
            return this.jsonFormatAnnotation.get().pattern();
        }
        return null;
    }
}

