/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.property.field;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.ModelPropertyBuilder;
import springfox.documentation.schema.Annotations;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.configuration.ObjectMapperConfigured;
import springfox.documentation.schema.plugins.SchemaPluginsManager;
import springfox.documentation.schema.property.BeanPropertyDefinitions;
import springfox.documentation.schema.property.BeanPropertyNamingStrategy;
import springfox.documentation.schema.property.ModelPropertiesProvider;
import springfox.documentation.schema.property.field.FieldModelProperty;
import springfox.documentation.schema.property.field.FieldProvider;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;

@Component
public class FieldModelPropertyProvider
implements ModelPropertiesProvider {
    private static final Logger LOG = LoggerFactory.getLogger(FieldModelPropertyProvider.class);
    private final FieldProvider fieldProvider;
    private final BeanPropertyNamingStrategy namingStrategy;
    private final SchemaPluginsManager schemaPluginsManager;
    private final TypeNameExtractor typeNameExtractor;
    protected ObjectMapper objectMapper;

    @Autowired
    public FieldModelPropertyProvider(FieldProvider fieldProvider, BeanPropertyNamingStrategy namingStrategy, SchemaPluginsManager schemaPluginsManager, TypeNameExtractor typeNameExtractor) {
        this.fieldProvider = fieldProvider;
        this.namingStrategy = namingStrategy;
        this.schemaPluginsManager = schemaPluginsManager;
        this.typeNameExtractor = typeNameExtractor;
    }

    @VisibleForTesting
    List<ModelProperty> serializationCandidates(AnnotatedMember member, ResolvedField childField, Optional<BeanPropertyDefinition> jacksonProperty, ModelContext givenContext) {
        if (Annotations.memberIsUnwrapped(member)) {
            LOG.debug("Evaluating unwrapped member");
            return this.propertiesFor(childField.getType(), ModelContext.fromParent((ModelContext)givenContext, (ResolvedType)childField.getType()));
        }
        String fieldName = BeanPropertyDefinitions.name((BeanPropertyDefinition)jacksonProperty.get(), true, this.namingStrategy);
        return FluentIterable.from((Iterable)Lists.newArrayList((Object[])new ModelProperty[]{this.modelPropertyFrom(childField, fieldName, givenContext)})).filter(Predicates.not(BeanPropertyDefinitions.ignorable(givenContext))).toList();
    }

    private ModelProperty modelPropertyFrom(ResolvedField childField, String fieldName, ModelContext modelContext) {
        FieldModelProperty fieldModelProperty = new FieldModelProperty(fieldName, childField, modelContext.getAlternateTypeProvider());
        ModelPropertyBuilder propertyBuilder = new ModelPropertyBuilder().name(fieldModelProperty.getName()).type(fieldModelProperty.getType()).qualifiedType(fieldModelProperty.qualifiedTypeName()).position(fieldModelProperty.position()).readOnly(Boolean.valueOf(fieldModelProperty.isReadOnly())).required(Boolean.valueOf(fieldModelProperty.isRequired())).description(fieldModelProperty.propertyDescription()).allowableValues(fieldModelProperty.allowableValues());
        return this.schemaPluginsManager.property(new ModelPropertyContext(propertyBuilder, (AnnotatedElement)((Object)childField.getRawMember()), new TypeResolver(), modelContext.getDocumentationType())).updateModelRef(ResolvedTypes.modelRefFactory(modelContext, this.typeNameExtractor));
    }

    @Override
    public List<ModelProperty> propertiesFor(ResolvedType type, ModelContext givenContext) {
        ArrayList serializationCandidates = Lists.newArrayList();
        BeanDescription beanDescription = this.beanDescription(type, givenContext);
        ImmutableMap propertyLookup = Maps.uniqueIndex((Iterable)beanDescription.findProperties(), BeanPropertyDefinitions.beanPropertyByInternalName());
        for (ResolvedField childField : this.fieldProvider.in(type)) {
            LOG.debug("Reading property {}", (Object)childField.getName());
            if (!propertyLookup.containsKey(childField.getName())) continue;
            BeanPropertyDefinition propertyDefinition = (BeanPropertyDefinition)propertyLookup.get(childField.getName());
            Optional<BeanPropertyDefinition> jacksonProperty = BeanPropertyDefinitions.jacksonPropertyWithSameInternalName(beanDescription, propertyDefinition);
            AnnotatedField member = propertyDefinition.getField();
            serializationCandidates.addAll(Lists.newArrayList(this.serializationCandidates((AnnotatedMember)member, childField, jacksonProperty, givenContext)));
        }
        return serializationCandidates;
    }

    private BeanDescription beanDescription(ResolvedType type, ModelContext context) {
        if (context.isReturnType()) {
            SerializationConfig serializationConfig = this.objectMapper.getSerializationConfig();
            return serializationConfig.introspect(TypeFactory.defaultInstance().constructType((Type)type.getErasedType()));
        }
        DeserializationConfig serializationConfig = this.objectMapper.getDeserializationConfig();
        return serializationConfig.introspect(TypeFactory.defaultInstance().constructType((Type)type.getErasedType()));
    }

    public void onApplicationEvent(ObjectMapperConfigured event) {
        this.objectMapper = event.getObjectMapper();
    }
}

