/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.property;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.members.ResolvedMember;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.ModelPropertyBuilder;
import springfox.documentation.schema.Annotations;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.configuration.ObjectMapperConfigured;
import springfox.documentation.schema.plugins.SchemaPluginsManager;
import springfox.documentation.schema.property.BeanPropertyDefinitions;
import springfox.documentation.schema.property.BeanPropertyNamingStrategy;
import springfox.documentation.schema.property.ModelPropertiesProvider;
import springfox.documentation.schema.property.bean.Accessors;
import springfox.documentation.schema.property.bean.AccessorsProvider;
import springfox.documentation.schema.property.bean.BeanModelProperty;
import springfox.documentation.schema.property.field.FieldModelProperty;
import springfox.documentation.schema.property.field.FieldProvider;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;

@Primary
@Component(value="optimized")
public class OptimizedModelPropertiesProvider
implements ModelPropertiesProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OptimizedModelPropertiesProvider.class);
    private final AccessorsProvider accessors;
    private final FieldProvider fields;
    private final TypeResolver typeResolver;
    private final BeanPropertyNamingStrategy namingStrategy;
    private final SchemaPluginsManager schemaPluginsManager;
    private final TypeNameExtractor typeNameExtractor;
    private ObjectMapper objectMapper;

    @Autowired
    public OptimizedModelPropertiesProvider(AccessorsProvider accessors, FieldProvider fields, TypeResolver typeResolver, BeanPropertyNamingStrategy namingStrategy, SchemaPluginsManager schemaPluginsManager, TypeNameExtractor typeNameExtractor) {
        this.accessors = accessors;
        this.fields = fields;
        this.typeResolver = typeResolver;
        this.namingStrategy = namingStrategy;
        this.schemaPluginsManager = schemaPluginsManager;
        this.typeNameExtractor = typeNameExtractor;
    }

    public void onApplicationEvent(ObjectMapperConfigured event) {
        this.objectMapper = event.getObjectMapper();
    }

    @Override
    @Cacheable(value={"modelProperties"}, key="T(springfox.documentation.schema.ModelCacheKeys).modelPropertiesKey(#type, #givenContext)")
    public List<ModelProperty> propertiesFor(ResolvedType type, ModelContext givenContext) {
        ArrayList properties = Lists.newArrayList();
        BeanDescription beanDescription = this.beanDescription(type, givenContext);
        ImmutableMap propertyLookup = Maps.uniqueIndex((Iterable)beanDescription.findProperties(), BeanPropertyDefinitions.beanPropertyByInternalName());
        for (Map.Entry each : propertyLookup.entrySet()) {
            LOG.debug("Reading property {}", each.getKey());
            BeanPropertyDefinition jacksonProperty = (BeanPropertyDefinition)each.getValue();
            Optional annotatedMember = Optional.fromNullable((Object)jacksonProperty.getPrimaryMember());
            if (!annotatedMember.isPresent()) continue;
            properties.addAll(this.candidateProperties(type, (AnnotatedMember)annotatedMember.get(), jacksonProperty, givenContext));
        }
        return properties;
    }

    private Function<ResolvedMethod, List<ModelProperty>> propertyFromBean(final ModelContext givenContext, final BeanPropertyDefinition jacksonProperty) {
        return new Function<ResolvedMethod, List<ModelProperty>>(){

            public List<ModelProperty> apply(ResolvedMethod input) {
                ResolvedType type = BeanModelProperty.paramOrReturnType(OptimizedModelPropertiesProvider.this.typeResolver, input);
                if (!givenContext.hasSeenBefore(type)) {
                    if (OptimizedModelPropertiesProvider.this.shouldUnwrap(input)) {
                        return OptimizedModelPropertiesProvider.this.propertiesFor(type, ModelContext.fromParent((ModelContext)givenContext, (ResolvedType)type));
                    }
                    return Lists.newArrayList((Object[])new ModelProperty[]{OptimizedModelPropertiesProvider.this.beanModelProperty(input, jacksonProperty, givenContext)});
                }
                return Lists.newArrayList();
            }
        };
    }

    private boolean shouldUnwrap(ResolvedMethod input) {
        return Iterables.any((Iterable)Lists.newArrayList((Object[])((Method)input.getRawMember()).getDeclaredAnnotations()), this.ofType(JsonUnwrapped.class));
    }

    private Function<ResolvedField, List<ModelProperty>> propertyFromField(final ModelContext givenContext, final BeanPropertyDefinition jacksonProperty) {
        return new Function<ResolvedField, List<ModelProperty>>(){

            public List<ModelProperty> apply(ResolvedField input) {
                if (Iterables.any((Iterable)input.getAnnotations(), (Predicate)OptimizedModelPropertiesProvider.this.ofType(JsonUnwrapped.class))) {
                    OptimizedModelPropertiesProvider.this.propertiesFor(input.getType(), ModelContext.fromParent((ModelContext)givenContext, (ResolvedType)input.getType()));
                }
                return Lists.newArrayList((Object[])new ModelProperty[]{OptimizedModelPropertiesProvider.this.fieldModelProperty(input, jacksonProperty, givenContext)});
            }
        };
    }

    private Predicate<? super Annotation> ofType(final Class<?> annotationType) {
        return new Predicate<Annotation>(){

            public boolean apply(Annotation input) {
                return annotationType.isAssignableFrom(input.getClass());
            }
        };
    }

    @VisibleForTesting
    List<ModelProperty> candidateProperties(ResolvedType type, AnnotatedMember member, BeanPropertyDefinition jacksonProperty, ModelContext givenContext) {
        ArrayList properties = Lists.newArrayList();
        if (member instanceof AnnotatedMethod) {
            properties.addAll((Collection)this.findAccessorMethod(type, jacksonProperty.getInternalName(), member).transform(this.propertyFromBean(givenContext, jacksonProperty)).or(new ArrayList()));
        } else if (member instanceof AnnotatedField) {
            properties.addAll((Collection)this.findField(type, jacksonProperty.getName()).transform(this.propertyFromField(givenContext, jacksonProperty)).or(new ArrayList()));
        }
        return properties;
    }

    private Optional<ResolvedField> findField(ResolvedType resolvedType, final String fieldName) {
        return Iterables.tryFind(this.fields.in(resolvedType), (Predicate)new Predicate<ResolvedField>(){

            public boolean apply(ResolvedField input) {
                return fieldName.equals(input.getName());
            }
        });
    }

    private ModelProperty fieldModelProperty(ResolvedField childField, BeanPropertyDefinition jacksonProperty, ModelContext modelContext) {
        String fieldName = BeanPropertyDefinitions.name(jacksonProperty, modelContext.isReturnType(), this.namingStrategy);
        FieldModelProperty fieldModelProperty = new FieldModelProperty(fieldName, childField, modelContext.getAlternateTypeProvider());
        ModelPropertyBuilder propertyBuilder = new ModelPropertyBuilder().name(fieldModelProperty.getName()).type(fieldModelProperty.getType()).qualifiedType(fieldModelProperty.qualifiedTypeName()).position(fieldModelProperty.position()).required(Boolean.valueOf(fieldModelProperty.isRequired())).description(fieldModelProperty.propertyDescription()).allowableValues(fieldModelProperty.allowableValues());
        return this.schemaPluginsManager.property(new ModelPropertyContext(propertyBuilder, (AnnotatedElement)((Object)childField.getRawMember()), this.typeResolver, modelContext.getDocumentationType())).updateModelRef(ResolvedTypes.modelRefFactory(modelContext, this.typeNameExtractor));
    }

    private ModelProperty beanModelProperty(ResolvedMethod childProperty, BeanPropertyDefinition jacksonProperty, ModelContext modelContext) {
        String propertyName = BeanPropertyDefinitions.name(jacksonProperty, modelContext.isReturnType(), this.namingStrategy);
        BeanModelProperty beanModelProperty = new BeanModelProperty(propertyName, childProperty, Accessors.isGetter((Method)childProperty.getRawMember()), this.typeResolver, modelContext.getAlternateTypeProvider());
        LOG.debug("Adding property {} to model", (Object)propertyName);
        ModelPropertyBuilder propertyBuilder = new ModelPropertyBuilder().name(beanModelProperty.getName()).type(beanModelProperty.getType()).qualifiedType(beanModelProperty.qualifiedTypeName()).position(beanModelProperty.position()).required(Boolean.valueOf(beanModelProperty.isRequired())).isHidden(Boolean.valueOf(false)).description(beanModelProperty.propertyDescription()).allowableValues(beanModelProperty.allowableValues());
        return this.schemaPluginsManager.property(new ModelPropertyContext(propertyBuilder, jacksonProperty, this.typeResolver, modelContext.getDocumentationType())).updateModelRef(ResolvedTypes.modelRefFactory(modelContext, this.typeNameExtractor));
    }

    private Optional<ResolvedMethod> findAccessorMethod(ResolvedType resolvedType, final String propertyName, final AnnotatedMember member) {
        return Iterables.tryFind(this.accessors.in(resolvedType), (Predicate)new Predicate<ResolvedMethod>(){

            public boolean apply(ResolvedMethod accessorMethod) {
                return BeanModelProperty.accessorMemberIs((ResolvedMember)accessorMethod, Annotations.memberName(member)) && propertyName.equals(Accessors.propertyName((Method)accessorMethod.getRawMember()));
            }
        });
    }

    private BeanDescription beanDescription(ResolvedType type, ModelContext context) {
        if (context.isReturnType()) {
            SerializationConfig serializationConfig = this.objectMapper.getSerializationConfig();
            return serializationConfig.introspect(TypeFactory.defaultInstance().constructType((Type)type.getErasedType()));
        }
        DeserializationConfig serializationConfig = this.objectMapper.getDeserializationConfig();
        return serializationConfig.introspect(TypeFactory.defaultInstance().constructType((Type)type.getErasedType()));
    }
}

