/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.property;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.stereotype.Component;
import springfox.documentation.spi.schema.contexts.ModelContext;

@Component
public class ModelPropertiesKeyGenerator
implements KeyGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(ModelPropertiesKeyGenerator.class);

    public Object generate(Object target, Method method, Object ... params) {
        Optional type = FluentIterable.from((Iterable)Lists.newArrayList((Object[])params)).filter(ResolvedType.class).first();
        Optional context = FluentIterable.from((Iterable)Lists.newArrayList((Object[])params)).filter(ModelContext.class).first();
        if (!type.isPresent()) {
            throw new IllegalArgumentException("Key generator can only be used where atleast one parameter is of type ResolvedType");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(((ResolvedType)type.get()).toString());
        sb.append((String)context.transform(this.returnTypeComponent()).or((Object)""));
        LOG.info("Cache key generated: {}", (Object)sb.toString());
        return sb.toString();
    }

    private Function<ModelContext, String> returnTypeComponent() {
        return new Function<ModelContext, String>(){

            public String apply(ModelContext input) {
                return String.format("(%s)", input.isReturnType());
            }
        };
    }
}

