/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest.schema;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resources;
import springfox.documentation.builders.ModelPropertyBuilder;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.Xml;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.SyntheticModelProviderPlugin;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spring.data.rest.schema.EmbeddedCollection;

class ResourcesModelProvider
implements SyntheticModelProviderPlugin {
    private final TypeResolver resolver;
    private final TypeNameExtractor typeNameExtractor;

    ResourcesModelProvider(TypeResolver resolver, TypeNameExtractor typeNameExtractor) {
        this.resolver = resolver;
        this.typeNameExtractor = typeNameExtractor;
    }

    public Model create(ModelContext context) {
        ResolvedType resourceType = this.resourceType(context.getType());
        List typeParameters = resourceType.getTypeParameters();
        Class type = ((ResolvedType)typeParameters.get(0)).getErasedType();
        String name = this.typeNameExtractor.typeName(context);
        return context.getBuilder().description(String.format("Resources of %s", type.getSimpleName())).name(name).id(name).qualifiedType(type.getName()).type((ResolvedType)typeParameters.get(0)).properties((Map)Maps.uniqueIndex(this.properties(context), this.byName())).xml(new Xml().name("entities").wrapped(Boolean.valueOf(false)).attribute(Boolean.valueOf(false))).build();
    }

    public List<ModelProperty> properties(ModelContext context) {
        ResolvedType resourceType = this.resourceType(context.getType());
        List typeParameters = resourceType.getTypeParameters();
        Class type = ((ResolvedType)typeParameters.get(0)).getErasedType();
        ResolvedType embedded = this.resolver.resolve(EmbeddedCollection.class, new Type[]{type});
        ResolvedType mapOfLinks = this.resolver.resolve(Map.class, new Type[]{String.class, Link.class});
        return Lists.newArrayList((Object[])new ModelProperty[]{new ModelPropertyBuilder().name("_embedded").type(embedded).qualifiedType(embedded.getSignature()).position(0).required(Boolean.valueOf(true)).isHidden(Boolean.valueOf(false)).build().updateModelRef(ResolvedTypes.modelRefFactory((ModelContext)context, (TypeNameExtractor)this.typeNameExtractor)), new ModelPropertyBuilder().name("_links").type(mapOfLinks).qualifiedType(mapOfLinks.getSignature()).position(1).required(Boolean.valueOf(true)).isHidden(Boolean.valueOf(false)).description("Link collection").build().updateModelRef(ResolvedTypes.modelRefFactory((ModelContext)context, (TypeNameExtractor)this.typeNameExtractor))});
    }

    public Set<ResolvedType> dependencies(ModelContext context) {
        ResolvedType resourceType = this.resourceType(context.getType());
        List typeParameters = resourceType.getTypeParameters();
        Class type = ((ResolvedType)typeParameters.get(0)).getErasedType();
        return Sets.newHashSet((Object[])new ResolvedType[]{this.resolver.resolve(EmbeddedCollection.class, new Type[]{type}), this.resolver.resolve(Link.class, new Type[0])});
    }

    public boolean supports(ModelContext delimiter) {
        return Resources.class.equals((Object)this.resourceType(delimiter.getType()).getErasedType()) && delimiter.getDocumentationType() == DocumentationType.SWAGGER_2;
    }

    private Function<ModelProperty, String> byName() {
        return new Function<ModelProperty, String>(){

            public String apply(ModelProperty input) {
                return input.getName();
            }
        };
    }

    private ResolvedType resourceType(Type type) {
        return this.resolver.resolve(type, new Type[0]);
    }
}

