/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.webmvc.BasePathAwareHandlerMapping;
import org.springframework.data.rest.webmvc.alps.AlpsController;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import springfox.documentation.RequestHandler;
import springfox.documentation.spi.service.RequestHandlerProvider;
import springfox.documentation.spring.web.WebMvcRequestHandler;

@Component
public class BasePathAwareServicesProvider
implements RequestHandlerProvider {
    private final BasePathAwareHandlerMapping basePathAwareMappings;

    public BasePathAwareServicesProvider(RepositoryRestConfiguration repositoryConfiguration, ApplicationContext applicationContext) {
        this.basePathAwareMappings = new BasePathAwareHandlerMapping(repositoryConfiguration);
        this.basePathAwareMappings.setApplicationContext(applicationContext);
        this.basePathAwareMappings.afterPropertiesSet();
    }

    public List<RequestHandler> requestHandlers() {
        ArrayList requestHandlers = Lists.newArrayList();
        for (Map.Entry each : this.basePathAwareMappings.getHandlerMethods().entrySet()) {
            if (BasePathAwareServicesProvider.isEntitySchemaService((HandlerMethod)each.getValue()) || BasePathAwareServicesProvider.isAlpsProfileServices((HandlerMethod)each.getValue())) continue;
            requestHandlers.add(new WebMvcRequestHandler((RequestMappingInfo)each.getKey(), (HandlerMethod)each.getValue()));
        }
        return requestHandlers;
    }

    private static boolean isEntitySchemaService(HandlerMethod input) {
        return input.getBeanType().getSimpleName().equals("RepositorySchemaController");
    }

    private static boolean isAlpsProfileServices(HandlerMethod input) {
        return AlpsController.class.equals((Object)input.getBeanType());
    }
}

