/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.NameValueExpression;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import springfox.documentation.RequestHandler;
import springfox.documentation.RequestHandlerKey;
import springfox.documentation.service.ResolvedMethodParameter;

class CombinedRequestHandler
implements RequestHandler {
    private final RequestHandler first;
    private final RequestHandler second;

    CombinedRequestHandler(RequestHandler first, RequestHandler second) {
        this.first = first;
        this.second = second;
    }

    public Class<?> declaringClass() {
        return this.first.declaringClass();
    }

    public boolean isAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.first.isAnnotatedWith(annotation) || this.second.isAnnotatedWith(annotation);
    }

    public PatternsRequestCondition getPatternsCondition() {
        HashSet patterns = Sets.newHashSet((Iterable)this.first.getPatternsCondition().getPatterns());
        patterns.addAll(this.second.getPatternsCondition().getPatterns());
        return new PatternsRequestCondition(patterns.toArray(new String[patterns.size()]));
    }

    public String groupName() {
        return this.first.groupName();
    }

    public String getName() {
        return this.first.getName();
    }

    public Set<RequestMethod> supportedMethods() {
        HashSet requestMethods = Sets.newHashSet((Iterable)this.first.supportedMethods());
        requestMethods.addAll(this.second.supportedMethods());
        return requestMethods;
    }

    public Set<? extends MediaType> produces() {
        HashSet mediaTypes = Sets.newHashSet((Iterable)this.first.produces());
        mediaTypes.addAll(this.second.produces());
        return mediaTypes;
    }

    public Set<? extends MediaType> consumes() {
        HashSet mediaTypes = Sets.newHashSet((Iterable)this.first.consumes());
        mediaTypes.addAll(this.second.consumes());
        return mediaTypes;
    }

    public Set<NameValueExpression<String>> headers() {
        return this.first.headers();
    }

    public Set<NameValueExpression<String>> params() {
        return this.first.params();
    }

    public <T extends Annotation> Optional<T> findAnnotation(Class<T> annotation) {
        return this.first.findAnnotation(annotation).or(this.second.findAnnotation(annotation));
    }

    public RequestHandlerKey key() {
        return new RequestHandlerKey(this.getPatternsCondition().getPatterns(), this.supportedMethods(), this.consumes(), this.produces());
    }

    public List<ResolvedMethodParameter> getParameters() {
        return this.first.getParameters();
    }

    public ResolvedType getReturnType() {
        return this.first.getReturnType();
    }

    public <T extends Annotation> Optional<T> findControllerAnnotation(Class<T> annotation) {
        return this.first.findAnnotation(annotation).or(this.second.findAnnotation(annotation));
    }

    public RequestMappingInfo getRequestMapping() {
        return this.first.getRequestMapping();
    }

    public HandlerMethod getHandlerMethod() {
        return this.second.getHandlerMethod();
    }

    public RequestHandler combine(RequestHandler other) {
        return new CombinedRequestHandler(this, other);
    }
}

