/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceType;
import org.springframework.data.rest.webmvc.BasePathAwareHandlerMapping;
import org.springframework.data.rest.webmvc.RepositoryRestHandlerMapping;
import org.springframework.data.rest.webmvc.RestMediaTypes;
import org.springframework.data.rest.webmvc.support.JpaHelper;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import springfox.documentation.RequestHandler;
import springfox.documentation.spi.service.RequestHandlerProvider;
import springfox.documentation.spring.data.rest.EntityRequestTemplate;
import springfox.documentation.spring.data.rest.EntitySchemaTemplate;
import springfox.documentation.spring.data.rest.EntitySearchRequestHandler;
import springfox.documentation.spring.data.rest.EntitySearchRequestTemplate;
import springfox.documentation.spring.data.rest.EntityServices;
import springfox.documentation.spring.web.WebMvcRequestHandler;

@Component
class EntityServicesProvider
implements RequestHandlerProvider {
    private final ResourceMappings mappings;
    private final Repositories repositories;
    private final RepositoryRestHandlerMapping restMappings;
    private final BasePathAwareHandlerMapping basePathAwareMappings;
    private final TypeResolver typeResolver;

    @Autowired
    EntityServicesProvider(ResourceMappings mappings, JpaHelper jpaHelper, RepositoryRestConfiguration repositoryConfiguration, ApplicationContext applicationContext, Repositories repositories, TypeResolver typeResolver) {
        this.mappings = mappings;
        this.repositories = repositories;
        this.typeResolver = typeResolver;
        this.restMappings = new RepositoryRestHandlerMapping(mappings, repositoryConfiguration);
        this.restMappings.setJpaHelper(jpaHelper);
        this.restMappings.setApplicationContext(applicationContext);
        this.restMappings.afterPropertiesSet();
        this.basePathAwareMappings = new BasePathAwareHandlerMapping(repositoryConfiguration);
        this.basePathAwareMappings.setApplicationContext(applicationContext);
        this.basePathAwareMappings.afterPropertiesSet();
    }

    public List<RequestHandler> requestHandlers() {
        ArrayList requestHandlers = Lists.newArrayList();
        FluentIterable entries = FluentIterable.from(this.allEntries());
        for (Map.Entry each : entries.filter(Predicates.not(EntityServices.restDataServices()))) {
            requestHandlers.add(new WebMvcRequestHandler((RequestMappingInfo)each.getKey(), (HandlerMethod)each.getValue()));
        }
        for (Map.Entry each : entries.filter(EntityServices.repositories())) {
            requestHandlers.add(new WebMvcRequestHandler((RequestMappingInfo)each.getKey(), (HandlerMethod)each.getValue()));
        }
        for (Map.Entry each : entries.filter(EntityServices.entityServices())) {
            EntityRequestTemplate entityRequestTemplate = new EntityRequestTemplate(this.typeResolver, this.repositories, this.mappings, (RequestMappingInfo)each.getKey(), (HandlerMethod)each.getValue());
            requestHandlers.addAll(entityRequestTemplate.operations());
        }
        ArrayList searchHandlers = Lists.newArrayList();
        for (Map.Entry each : entries.filter(EntityServices.entitySearchServices())) {
            EntitySearchRequestTemplate entityRequestHandlers = new EntitySearchRequestTemplate(this.typeResolver, this.mappings, (RequestMappingInfo)each.getKey(), (HandlerMethod)each.getValue());
            searchHandlers.addAll(entityRequestHandlers.operations());
        }
        requestHandlers.addAll(this.maybeCombine(searchHandlers, this.compactHandlers()));
        ArrayList metadataHandlers = Lists.newArrayList();
        for (Map.Entry each : this.basePathAwareMappings.getHandlerMethods().entrySet()) {
            if (EntityServices.entitySchemaService().apply(each) || EntityServices.alpsProfileServices().apply(each)) {
                metadataHandlers.addAll(new EntitySchemaTemplate(this.typeResolver, this.mappings, (RequestMappingInfo)each.getKey(), (HandlerMethod)each.getValue()).operations());
                continue;
            }
            requestHandlers.add(new WebMvcRequestHandler((RequestMappingInfo)each.getKey(), (HandlerMethod)each.getValue()));
        }
        requestHandlers.addAll(this.maybeCombine(metadataHandlers, this.supportsAlps()));
        requestHandlers.addAll(FluentIterable.from((Iterable)metadataHandlers).filter(this.optionMethods()).toList());
        return requestHandlers;
    }

    private Predicate<RequestHandler> optionMethods() {
        return new Predicate<RequestHandler>(){

            public boolean apply(RequestHandler input) {
                return input.supportedMethods().contains(RequestMethod.OPTIONS);
            }
        };
    }

    private Collection<RequestHandler> maybeCombine(List<RequestHandler> metadataHandlers, Predicate<RequestHandler> selector) {
        ArrayList combined = Lists.newArrayList();
        FluentIterable selected = FluentIterable.from(metadataHandlers).filter(Predicates.and(selector, this.getHandler()));
        FluentIterable selectedCompliment = FluentIterable.from(metadataHandlers).filter(Predicates.and((Predicate)Predicates.not(selector), this.getHandler()));
        for (RequestHandler each : selected) {
            Optional found = selectedCompliment.firstMatch(this.samePathMapping(each.getPatternsCondition()));
            combined.add(this.combine(each, (Optional<RequestHandler>)found));
        }
        combined.addAll(FluentIterable.from(metadataHandlers).filter(EntitySearchRequestHandler.class).filter(this.collectionHandlers()).toList());
        return combined;
    }

    private Predicate<EntitySearchRequestHandler> collectionHandlers() {
        return new Predicate<EntitySearchRequestHandler>(){

            public boolean apply(EntitySearchRequestHandler input) {
                return input.resourceType() == ResourceType.COLLECTION;
            }
        };
    }

    private RequestHandler combine(RequestHandler source, Optional<RequestHandler> other) {
        if (other.isPresent()) {
            return ((RequestHandler)other.get()).combine(source);
        }
        return source;
    }

    private Predicate<RequestHandler> samePathMapping(final PatternsRequestCondition pathMappings) {
        return new Predicate<RequestHandler>(){

            public boolean apply(RequestHandler input) {
                return input.getPatternsCondition().equals((Object)pathMappings);
            }
        };
    }

    private Predicate<RequestHandler> compactHandlers() {
        return new Predicate<RequestHandler>(){

            public boolean apply(RequestHandler input) {
                return input.key().getProducibleMediaTypes().contains(MediaType.valueOf((String)"application/x-spring-data-compact+json"));
            }
        };
    }

    private Predicate<RequestHandler> supportsAlps() {
        return new Predicate<RequestHandler>(){

            public boolean apply(RequestHandler input) {
                return input.key().getSupportedMediaTypes().contains(RestMediaTypes.ALPS_JSON);
            }
        };
    }

    private Predicate<RequestHandler> getHandler() {
        return new Predicate<RequestHandler>(){

            public boolean apply(RequestHandler input) {
                return input.key().getSupportedMethods().contains(RequestMethod.GET);
            }
        };
    }

    private Set<Map.Entry<RequestMappingInfo, HandlerMethod>> allEntries() {
        return this.restMappings.getHandlerMethods().entrySet();
    }
}

