/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import com.fasterxml.classmate.MemberResolver;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.rest.core.mapping.MethodResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.ResourceType;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.NameValueExpression;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.ProducesRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import springfox.documentation.RequestHandler;
import springfox.documentation.RequestHandlerKey;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spring.data.rest.CombinedRequestHandler;
import springfox.documentation.spring.data.rest.SynthesizedAnnotations;
import springfox.documentation.spring.web.paths.Paths;
import springfox.documentation.spring.web.readers.operation.HandlerMethodResolver;

class EntitySearchRequestHandler
implements RequestHandler {
    private final TypeResolver resolver;
    private final RequestMappingInfo requestMapping;
    private final HandlerMethod handlerMethod;
    private final MethodResourceMapping searchResource;
    private final ResourceMetadata resource;
    private final ResourceType resourceType;

    EntitySearchRequestHandler(TypeResolver resolver, RequestMappingInfo requestMapping, HandlerMethod handlerMethod, MethodResourceMapping searchResource, ResourceMetadata resource) {
        this.resolver = resolver;
        this.requestMapping = requestMapping;
        this.handlerMethod = handlerMethod;
        this.searchResource = searchResource;
        this.resource = resource;
        this.resourceType = this.resourceType();
    }

    public Class<?> declaringClass() {
        return this.searchResource.getMethod().getDeclaringClass();
    }

    public boolean isAnnotatedWith(Class<? extends Annotation> annotation) {
        return null != AnnotationUtils.findAnnotation((Method)this.searchResource.getMethod(), annotation);
    }

    public PatternsRequestCondition getPatternsCondition() {
        HashSet patterns = Sets.newHashSet();
        for (String each : this.requestMapping.getPatternsCondition().getPatterns()) {
            String replaced = each.replace("/{repository}", this.resource.getPath().toString()).replace("/{search}", this.searchResource.getPath().toString());
            patterns.add(replaced);
        }
        return new PatternsRequestCondition(patterns.toArray(new String[patterns.size()]));
    }

    public String groupName() {
        return String.format("%s Entity Search", Paths.splitCamelCase((String)this.resource.getDomainType().getSimpleName(), (String)""));
    }

    public String getName() {
        if (this.resourceType == ResourceType.ITEM) {
            return this.searchResource.getPath().toString();
        }
        return this.handlerMethod.getMethod().getName();
    }

    public Set<RequestMethod> supportedMethods() {
        return this.requestMapping.getMethodsCondition().getMethods();
    }

    public Set<? extends MediaType> produces() {
        ProducesRequestCondition producesCondition = this.requestMapping.getProducesCondition();
        if (this.searchResource.getDescription() != null) {
            MediaType type = this.searchResource.getDescription().getType();
            producesCondition.combine(new ProducesRequestCondition(new String[]{type.toString()}));
        }
        return producesCondition.getProducibleMediaTypes();
    }

    public Set<? extends MediaType> consumes() {
        return this.requestMapping.getConsumesCondition().getConsumableMediaTypes();
    }

    public Set<NameValueExpression<String>> headers() {
        return Sets.newHashSet();
    }

    public Set<NameValueExpression<String>> params() {
        return Sets.newHashSet();
    }

    public <T extends Annotation> Optional<T> findAnnotation(Class<T> annotation) {
        return Optional.fromNullable((Object)AnnotationUtils.findAnnotation((Method)this.handlerMethod.getMethod(), annotation));
    }

    public RequestHandlerKey key() {
        return new RequestHandlerKey(this.requestMapping.getPatternsCondition().getPatterns(), this.requestMapping.getMethodsCondition().getMethods(), this.requestMapping.getConsumesCondition().getConsumableMediaTypes(), this.requestMapping.getProducesCondition().getProducibleMediaTypes());
    }

    public List<ResolvedMethodParameter> getParameters() {
        HandlerMethodResolver handlerMethodResolver = new HandlerMethodResolver(this.resolver);
        if (this.resourceType() == ResourceType.ITEM) {
            List actualQueryParams = handlerMethodResolver.methodParameters(new HandlerMethod(this.searchResource.getMethod().getDeclaringClass(), this.searchResource.getMethod()));
            ImmutableList genericParams = FluentIterable.from((Iterable)handlerMethodResolver.methodParameters(new HandlerMethod((Object)this.searchResource, this.searchResource.getMethod()))).filter(this.maybeFilterSortParam(this.searchResource.isSortableResource())).filter(this.maybeFilterPagingParam(this.searchResource.isPagingResource())).toList();
            return FluentIterable.from((Iterable)Iterables.concat((Iterable)genericParams, (Iterable)actualQueryParams)).toList();
        }
        return FluentIterable.from((Iterable)handlerMethodResolver.methodParameters(this.handlerMethod)).transform(this.toIgnorable()).toList();
    }

    private Function<ResolvedMethodParameter, ResolvedMethodParameter> toIgnorable() {
        return new Function<ResolvedMethodParameter, ResolvedMethodParameter>(){

            public ResolvedMethodParameter apply(ResolvedMethodParameter input) {
                return input.annotate((Annotation)SynthesizedAnnotations.API_IGNORE_ANNOTATION);
            }
        };
    }

    private Predicate<ResolvedMethodParameter> maybeFilterSortParam(final boolean sortableResource) {
        return new Predicate<ResolvedMethodParameter>(){

            public boolean apply(ResolvedMethodParameter input) {
                boolean isSortParam = Sort.class.equals((Object)input.getParameterType().getErasedType());
                return sortableResource && isSortParam || !isSortParam;
            }
        };
    }

    private Predicate<ResolvedMethodParameter> maybeFilterPagingParam(final boolean pageableResource) {
        return new Predicate<ResolvedMethodParameter>(){

            public boolean apply(ResolvedMethodParameter input) {
                boolean isPageableParam = Pageable.class.equals((Object)input.getParameterType().getErasedType());
                return pageableResource && isPageableParam || !isPageableParam;
            }
        };
    }

    public ResolvedType getReturnType() {
        if (this.resourceType() == ResourceType.ITEM) {
            MemberResolver memberResolver = new MemberResolver(this.resolver);
            ResolvedTypeWithMembers members = memberResolver.resolve(this.resolver.resolve(this.searchResource.getMethod().getDeclaringClass(), new Type[0]), null, null);
            for (ResolvedMethod resolvedMethod : members.getMemberMethods()) {
                if (!((Method)resolvedMethod.getRawMember()).equals(this.searchResource.getMethod())) continue;
                return resolvedMethod.getReturnType();
            }
            return this.resolver.resolve(Void.TYPE, new Type[0]);
        }
        return this.resolver.resolve((Type)this.handlerMethod.getReturnType().getParameterType(), new Type[0]);
    }

    public <T extends Annotation> Optional<T> findControllerAnnotation(Class<T> annotation) {
        return Optional.fromNullable((Object)AnnotationUtils.findAnnotation((Class)this.handlerMethod.getBeanType(), annotation));
    }

    public RequestMappingInfo getRequestMapping() {
        return this.requestMapping;
    }

    public HandlerMethod getHandlerMethod() {
        return this.handlerMethod;
    }

    public RequestHandler combine(RequestHandler other) {
        return new CombinedRequestHandler(this, other);
    }

    ResourceType resourceType() {
        Set patterns = this.requestMapping.getPatternsCondition().getPatterns();
        if (Iterables.any((Iterable)patterns, this.endsWith("/{search}"))) {
            return ResourceType.ITEM;
        }
        return ResourceType.COLLECTION;
    }

    private Predicate<String> endsWith(final String pattern) {
        return new Predicate<String>(){

            public boolean apply(String input) {
                return input.contains(pattern);
            }
        };
    }
}

