/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest.schema;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.server.LinkRelationProvider;
import springfox.documentation.builders.ModelPropertyBuilder;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.Xml;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.schema.SyntheticModelProviderPlugin;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spring.data.rest.schema.EmbeddedCollection;

class EmbeddedCollectionModelProvider
implements SyntheticModelProviderPlugin {
    private final TypeResolver resolver;
    private final LinkRelationProvider relProvider;
    private final TypeNameExtractor typeNameExtractor;
    private final EnumTypeDeterminer enumTypeDeterminer;

    EmbeddedCollectionModelProvider(TypeResolver resolver, LinkRelationProvider relProvider, TypeNameExtractor typeNameExtractor, EnumTypeDeterminer enumTypeDeterminer) {
        this.resolver = resolver;
        this.relProvider = relProvider;
        this.typeNameExtractor = typeNameExtractor;
        this.enumTypeDeterminer = enumTypeDeterminer;
    }

    public Model create(ModelContext context) {
        ResolvedType resourceType = this.resolver.resolve((Type)context.getType(), new Type[0]);
        List typeParameters = resourceType.getTypeParameters();
        Class type = ((ResolvedType)typeParameters.get(0)).getErasedType();
        String name = this.typeNameExtractor.typeName(context);
        return context.getBuilder().description(String.format("Embedded collection of %s", type.getSimpleName())).name(name).qualifiedType(type.getName()).type((ResolvedType)typeParameters.get(0)).properties(this.properties(context).stream().collect(Collectors.toMap(ModelProperty::getName, Function.identity()))).xml(new Xml().wrapped(Boolean.valueOf(true)).name("content")).build();
    }

    public List<ModelProperty> properties(ModelContext context) {
        ResolvedType resourceType = this.resolver.resolve((Type)context.getType(), new Type[0]);
        List typeParameters = resourceType.getTypeParameters();
        Class type = ((ResolvedType)typeParameters.get(0)).getErasedType();
        return Collections.singletonList(new ModelPropertyBuilder().name(this.relProvider.getCollectionResourceRelFor(type).value()).type(this.resolver.resolve(List.class, new Type[]{type})).qualifiedType(CollectionModel.class.getName()).position(0).required(Boolean.valueOf(true)).isHidden(Boolean.valueOf(false)).description("Resource collection").build().updateModelRef(ResolvedTypes.modelRefFactory((ModelContext)context, (EnumTypeDeterminer)this.enumTypeDeterminer, (TypeNameExtractor)this.typeNameExtractor)));
    }

    public Set<ResolvedType> dependencies(ModelContext context) {
        ResolvedType resourceType = this.resolver.resolve((Type)context.getType(), new Type[0]);
        List typeParameters = resourceType.getTypeParameters();
        Class type = ((ResolvedType)typeParameters.get(0)).getErasedType();
        return Collections.singleton(this.resolver.resolve((Type)type, new Type[0]));
    }

    public boolean supports(ModelContext delimiter) {
        return EmbeddedCollection.class.equals((Object)this.resolver.resolve((Type)delimiter.getType(), new Type[0]).getErasedType()) && delimiter.getDocumentationType() == DocumentationType.SWAGGER_2;
    }
}

