/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.Parameters;
import springfox.documentation.service.Parameter;

class ParameterMerger {
    private final List<Parameter> destination;
    private final List<Parameter> source;

    public ParameterMerger(List<Parameter> destination, List<Parameter> source) {
        this.destination = Lists.newArrayList(destination);
        this.source = Lists.newArrayList(source);
    }

    public List<Parameter> merged() {
        ImmutableSet existingParameterNames = FluentIterable.from(this.destination).transform(Parameters.toParameterName()).toSet();
        ImmutableSet newParameterNames = FluentIterable.from(this.source).transform(Parameters.toParameterName()).toSet();
        ArrayList merged = Lists.newArrayList();
        Sets.SetView asIsParams = Sets.difference((Set)existingParameterNames, (Set)newParameterNames);
        Sets.SetView missingParamNames = Sets.difference((Set)newParameterNames, (Set)existingParameterNames);
        Sets.SetView paramsToMerge = Sets.intersection((Set)newParameterNames, (Set)existingParameterNames);
        merged.addAll(this.asIsParameters((Sets.SetView<String>)asIsParams, this.destination));
        merged.addAll(this.newParameters((Sets.SetView<String>)missingParamNames, this.source));
        merged.addAll(this.mergedParameters((Sets.SetView<String>)paramsToMerge, this.destination, this.source));
        return merged;
    }

    private List<Parameter> asIsParameters(Sets.SetView<String> asIsParams, List<Parameter> source) {
        ArrayList parameters = Lists.newArrayList();
        for (Parameter each : source) {
            if (!asIsParams.contains((Object)each.getName())) continue;
            parameters.add(each);
        }
        return parameters;
    }

    private List<Parameter> mergedParameters(Sets.SetView<String> paramsToMerge, List<Parameter> existingParameters, List<Parameter> newParams) {
        ArrayList parameters = Lists.newArrayList();
        for (Parameter newParam : newParams) {
            Optional original = FluentIterable.from(existingParameters).firstMatch(Parameters.withName(newParam.getName()));
            if (!paramsToMerge.contains((Object)newParam.getName()) || !original.isPresent()) continue;
            parameters.add(this.merged((Parameter)original.get(), newParam));
        }
        return parameters;
    }

    private Parameter merged(Parameter destination, Parameter source) {
        return new ParameterBuilder().from(destination).name(source.getName()).allowableValues(source.getAllowableValues()).allowMultiple(source.isAllowMultiple()).defaultValue(source.getDefaultValue()).description(source.getDescription()).modelRef(source.getModelRef()).parameterAccess(source.getParamAccess()).parameterType(source.getParamType()).required(source.isRequired()).type((ResolvedType)source.getType().orNull()).build();
    }

    private List<Parameter> newParameters(Sets.SetView<String> missingParamNames, List<Parameter> newParams) {
        ArrayList parameters = Lists.newArrayList();
        for (Parameter each : newParams) {
            if (!missingParamNames.contains((Object)each.getName())) continue;
            parameters.add(each);
        }
        return parameters;
    }
}

