/*
 * Decompiled with CFR 0.152.
 */
package io.spring.configuration;

import io.spring.configuration.TimestampBatchTaskProperties;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.support.DefaultBatchConfiguration;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseBuilder;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableConfigurationProperties(value={TimestampBatchTaskProperties.class})
public class TimestampBatchTaskConfiguration
extends DefaultBatchConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(TimestampBatchTaskProperties.class);
    @Value(value="${spring.batch.jdbc.table-prefix:BATCH_}")
    private String tablePrefix;
    @Autowired
    private TimestampBatchTaskProperties config;

    @Bean
    @ConditionalOnProperty(name={"spring.datasource.driver-class-name"}, matchIfMissing=true, havingValue="matchonlyifmissing")
    public DataSource dataSource() {
        return new EmbeddedDatabaseBuilder().setType(EmbeddedDatabaseType.H2).addScript("/org/springframework/batch/core/schema-h2.sql").generateUniqueName(true).build();
    }

    protected String getTablePrefix() {
        return this.tablePrefix;
    }

    @Bean
    public Step job1step1(JobRepository jobRepository, PlatformTransactionManager springCloudTaskTransactionManager) {
        return new StepBuilder("job1step1", jobRepository).tasklet(this.getTasklet("Job1 was run with date %s"), springCloudTaskTransactionManager).build();
    }

    private Tasklet getTasklet(String format) {
        return (contribution, chunkContext) -> {
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.config.getFormat());
            contribution.getStepExecution().getExecutionContext().put("ctx1", (Object)"exec1");
            contribution.getStepExecution().getJobExecution().getExecutionContext().put("job-ctx1", (Object)"exec-job1");
            logger.info("{}:{}", (Object)contribution.getStepExecution().getStepName(), (Object)contribution.getStepExecution().getExecutionContext());
            logger.info("{}:{}", (Object)contribution.getStepExecution().getJobExecution().getJobInstance().getJobName(), (Object)contribution.getStepExecution().getJobExecution().getExecutionContext());
            logger.info(String.format(format, dateFormat.format(new Date())));
            return RepeatStatus.FINISHED;
        };
    }

    @Bean
    public Job job1(JobRepository jobRepository, Step job1step1) {
        return new JobBuilder("job1", jobRepository).start(job1step1).build();
    }

    @Bean
    public Step job2step1(JobRepository jobRepository, PlatformTransactionManager springCloudTaskTransactionManager) {
        return new StepBuilder("job2step1", jobRepository).tasklet(this.getTasklet("Job2 was run with date %s"), springCloudTaskTransactionManager).build();
    }

    @Bean
    public Job job2(JobRepository jobRepository, Step job2step1) {
        return new JobBuilder("job2", jobRepository).start(job2step1).build();
    }
}

