/*
 * Decompiled with CFR 0.152.
 */
package io.spring.nohttp.file;

import io.spring.nohttp.HttpMatchResult;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public abstract class HttpProcessor {
    private Set<String> httpMatches = new TreeSet<String>();

    public List<HttpMatchResult> processFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException(file + " does not exist");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException(file + " must be a valid file (i.e. not a directory)");
        }
        List<HttpMatchResult> matches = this.processHttpInFile(file);
        matches.forEach(match -> this.httpMatches.add(match.getHttp()));
        return matches;
    }

    abstract List<HttpMatchResult> processHttpInFile(File var1);

    public Set<String> getHttpMatches() {
        return Collections.unmodifiableSet(this.httpMatches);
    }
}

