/*
 * Decompiled with CFR 0.152.
 */
package io.spring.nohttp;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusHttpReplacer
implements Function<String, String> {
    private Logger logger = LoggerFactory.getLogger(StatusHttpReplacer.class);
    private static final Integer OK = 200;
    private ConcurrentMap<String, Integer> urlToStatus = new ConcurrentHashMap<String, Integer>();
    private int timeout = 1000;

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public String apply(String httpUrl) {
        String httpsUrl = httpUrl.replaceFirst("http", "https");
        Integer status = this.findStatus(httpsUrl);
        return OK.equals(status) ? httpsUrl : httpUrl;
    }

    private Integer findStatus(String url) {
        return this.urlToStatus.computeIfAbsent(url, key -> this.getStatus((String)key));
    }

    private Integer getStatus(String url) {
        this.logger.debug("Looking up status for {}", (Object)url);
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setConnectTimeout(this.timeout);
            connection.setReadTimeout(this.timeout);
            return connection.getResponseCode();
        }
        catch (Exception e) {
            return null;
        }
    }
}

