/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import io.spring.javaformat.checkstyle.check.AbstractSpringCheck;

public class SpringLambdaCheck
extends AbstractSpringCheck {
    private boolean singleArgumentParentheses = true;

    public int[] getAcceptableTokens() {
        return new int[]{181};
    }

    public void visitToken(DetailAST ast) {
        if (ast.getType() == 181 && ast.getParent() != null && ast.getParent().getType() != 208) {
            this.visitLambda(ast);
        }
    }

    private void visitLambda(DetailAST lambda) {
        if (this.hasSingleParameter(lambda)) {
            boolean hasParentheses = this.hasToken(lambda, 76);
            if (this.singleArgumentParentheses && !hasParentheses) {
                this.log(lambda.getLineNo(), lambda.getColumnNo(), "lambda.missingParen", new Object[0]);
            } else if (!this.singleArgumentParentheses && hasParentheses && !this.isUsingParametersToDefineType(lambda)) {
                this.log(lambda.getLineNo(), lambda.getColumnNo(), "lambda.unnecessaryParen", new Object[0]);
            }
        }
        DetailAST block = lambda.getLastChild();
        int statements = this.countDescendantsOfType(block, 45);
        int requireBlock = this.countDescendantsOfType(block, 72, 90, 7);
        if (statements == 1 && requireBlock == 0) {
            this.log(block.getLineNo(), block.getColumnNo(), "lambda.unnecessaryBlock", new Object[0]);
        }
    }

    private int countDescendantsOfType(DetailAST ast, int ... types) {
        int count = 0;
        for (int type : types) {
            count += ast.getChildCount(type);
        }
        for (DetailAST child = ast.getFirstChild(); child != null; child = child.getNextSibling()) {
            count += this.countDescendantsOfType(child, types);
        }
        return count;
    }

    private boolean hasSingleParameter(DetailAST lambda) {
        DetailAST parameters = lambda.findFirstToken(20);
        return parameters == null || parameters.getChildCount(21) == 1;
    }

    private boolean isUsingParametersToDefineType(DetailAST lambda) {
        DetailAST ast = lambda.findFirstToken(20);
        ast = ast != null ? ast.findFirstToken(21) : null;
        ast = ast != null ? ast.findFirstToken(13) : null;
        ast = ast != null ? ast.findFirstToken(58) : null;
        return ast != null;
    }

    private boolean hasToken(DetailAST ast, int type) {
        return ast.findFirstToken(type) != null;
    }

    public void setSingleArgumentParentheses(boolean singleArgumentParentheses) {
        this.singleArgumentParentheses = singleArgumentParentheses;
    }
}

