/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal;

import io.spring.gradle.dependencymanagement.internal.DependencyManagementConfigurationContainer;
import io.spring.gradle.dependencymanagement.internal.DependencyManagementContainer;
import io.spring.gradle.dependencymanagement.internal.DependencyManagementSettings;
import io.spring.gradle.dependencymanagement.internal.Exclusion;
import io.spring.gradle.dependencymanagement.internal.ExclusionResolver;
import io.spring.gradle.dependencymanagement.internal.Exclusions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyConstraintSet;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExclusionConfiguringAction
implements Action<ResolvableDependencies> {
    private static final Logger logger = LoggerFactory.getLogger(ExclusionConfiguringAction.class);
    private final DependencyManagementSettings dependencyManagementSettings;
    private final DependencyManagementContainer dependencyManagementContainer;
    private final DependencyManagementConfigurationContainer configurationContainer;
    private final Configuration configuration;
    private final ExclusionResolver exclusionResolver;
    private final DependencyManagementConfigurationContainer.ConfigurationConfigurer configurationConfigurer;

    ExclusionConfiguringAction(DependencyManagementSettings dependencyManagementSettings, DependencyManagementContainer dependencyManagementContainer, DependencyManagementConfigurationContainer configurationContainer, Configuration configuration, ExclusionResolver exclusionResolver, DependencyManagementConfigurationContainer.ConfigurationConfigurer configurationConfigurer) {
        this.dependencyManagementSettings = dependencyManagementSettings;
        this.dependencyManagementContainer = dependencyManagementContainer;
        this.configurationContainer = configurationContainer;
        this.configuration = configuration;
        this.exclusionResolver = exclusionResolver;
        this.configurationConfigurer = configurationConfigurer;
    }

    public void execute(ResolvableDependencies resolvableDependencies) {
        if (this.dependencyManagementSettings.isApplyMavenExclusions()) {
            this.applyMavenExclusions(resolvableDependencies);
        }
    }

    private void applyMavenExclusions(ResolvableDependencies resolvableDependencies) {
        Set<DependencyCandidate> excludedDependencies = this.findExcludedDependencies();
        logger.info("Excluding {}", excludedDependencies);
        for (Dependency dependency : resolvableDependencies.getDependencies()) {
            if (!(dependency instanceof ModuleDependency)) continue;
            for (DependencyCandidate excludedDependency : excludedDependencies) {
                ((ModuleDependency)dependency).exclude(excludedDependency.asMap());
            }
        }
    }

    private Set<DependencyCandidate> findExcludedDependencies() {
        ResolutionResult resolutionResult = this.copyConfiguration().getIncoming().getResolutionResult();
        ResolvedComponentResult root = resolutionResult.getRoot();
        HashSet<DependencyCandidate> excludedDependencies = new HashSet<DependencyCandidate>();
        resolutionResult.allDependencies(dependencyResult -> {
            DependencyCandidate dependencyCandidate;
            if (dependencyResult instanceof ResolvedDependencyResult) {
                ResolvedDependencyResult resolved = (ResolvedDependencyResult)dependencyResult;
                if (!resolved.isConstraint()) {
                    excludedDependencies.add(new DependencyCandidate(resolved.getSelected().getModuleVersion()));
                }
            } else if (dependencyResult instanceof UnresolvedDependencyResult && (dependencyCandidate = this.toDependencyCandidate((UnresolvedDependencyResult)dependencyResult)) != null) {
                excludedDependencies.add(dependencyCandidate);
            }
        });
        Set<DependencyCandidate> includedDependencies = this.determineIncludedComponents(root, this.exclusionResolver.resolveExclusions(resolutionResult.getAllComponents()));
        excludedDependencies.removeAll(includedDependencies);
        return excludedDependencies;
    }

    private Configuration copyConfiguration() {
        DependencySet allDependencies = this.configuration.getAllDependencies();
        Configuration configurationCopy = this.configurationContainer.newConfiguration(this.configurationConfigurer, (Dependency[])allDependencies.toArray((Object[])new Dependency[allDependencies.size()]));
        DependencyConstraintSet constraints = this.configuration.getAllDependencyConstraints();
        configurationCopy.getDependencyConstraints().addAll((Collection)constraints);
        return configurationCopy;
    }

    private Set<DependencyCandidate> determineIncludedComponents(ResolvedComponentResult root, Map<String, Exclusions> pomExclusionsById) {
        LinkedList<Node> queue = new LinkedList<Node>();
        queue.add(new Node(root, this.getId(root), new HashSet()));
        HashSet<ResolvedComponentResult> seen = new HashSet<ResolvedComponentResult>();
        HashSet<DependencyCandidate> includedComponents = new HashSet<DependencyCandidate>();
        while (!queue.isEmpty()) {
            Node node = (Node)queue.remove();
            includedComponents.add(new DependencyCandidate(node.component.getModuleVersion()));
            for (DependencyResult dependency : node.component.getDependencies()) {
                if (dependency instanceof ResolvedDependencyResult) {
                    this.handleResolvedDependency((ResolvedDependencyResult)dependency, node, pomExclusionsById, queue, seen);
                    continue;
                }
                if (!(dependency instanceof UnresolvedDependencyResult)) continue;
                this.handleUnresolvedDependency((UnresolvedDependencyResult)dependency, node, includedComponents);
            }
        }
        return includedComponents;
    }

    private void handleResolvedDependency(ResolvedDependencyResult dependency, Node node, Map<String, Exclusions> pomExclusionsById, LinkedList<Node> queue, Set<ResolvedComponentResult> seen) {
        ResolvedComponentResult child = dependency.getSelected();
        String childId = this.getId(child);
        if (!node.excluded(childId) && !dependency.isConstraint() && seen.add(child)) {
            queue.add(new Node(child, childId, this.getChildExclusions(node, childId, pomExclusionsById)));
        }
    }

    private void handleUnresolvedDependency(UnresolvedDependencyResult dependency, Node node, Set<DependencyCandidate> includedComponents) {
        DependencyCandidate dependencyCandidate = this.toDependencyCandidate(dependency);
        if (dependencyCandidate != null && !node.excluded(dependencyCandidate.getGroupAndArtifactId())) {
            includedComponents.add(dependencyCandidate);
        }
    }

    private DependencyCandidate toDependencyCandidate(UnresolvedDependencyResult unresolved) {
        ComponentSelector attemptedSelector = unresolved.getAttempted();
        if (!(attemptedSelector instanceof ModuleComponentSelector)) {
            return null;
        }
        ModuleComponentSelector attemptedModuleSelector = (ModuleComponentSelector)attemptedSelector;
        return new DependencyCandidate(attemptedModuleSelector.getGroup(), attemptedModuleSelector.getModule());
    }

    private Set<Exclusion> getChildExclusions(Node parent, String childId, Map<String, Exclusions> pomExclusionsById) {
        HashSet<Exclusion> childExclusions = new HashSet<Exclusion>(parent.exclusions);
        this.addAllIfPossible(childExclusions, this.dependencyManagementContainer.getExclusions(this.configuration).exclusionsForDependency(childId));
        Exclusions exclusionsInPom = pomExclusionsById.get(parent.id);
        if (exclusionsInPom != null) {
            this.addAllIfPossible(childExclusions, exclusionsInPom.exclusionsForDependency(childId));
        }
        return childExclusions;
    }

    private void addAllIfPossible(Set<Exclusion> current, Set<Exclusion> addition) {
        if (addition != null) {
            current.addAll(addition);
        }
    }

    private String getId(ResolvedComponentResult component) {
        return component.getModuleVersion().getGroup() + ":" + component.getModuleVersion().getName();
    }

    private static final class DependencyCandidate {
        private final String groupId;
        private final String artifactId;

        private DependencyCandidate(ModuleVersionIdentifier identifier) {
            this(identifier.getGroup(), identifier.getName());
        }

        private DependencyCandidate(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DependencyCandidate other = (DependencyCandidate)o;
            boolean result = this.groupId.equals(other.groupId);
            result = result && this.artifactId.equals(other.artifactId);
            return result;
        }

        public int hashCode() {
            int result = this.groupId.hashCode();
            result = 31 * result + this.artifactId.hashCode();
            return result;
        }

        Map<String, String> asMap() {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("group", this.groupId);
            map.put("module", this.artifactId);
            return Collections.unmodifiableMap(map);
        }

        public String toString() {
            return this.getGroupAndArtifactId();
        }

        String getGroupAndArtifactId() {
            return this.groupId + ":" + this.artifactId;
        }
    }

    private static final class Node {
        private final ResolvedComponentResult component;
        private final String id;
        private final Set<Exclusion> exclusions;

        private Node(ResolvedComponentResult component, String id, Set<Exclusion> exclusions) {
            this.component = component;
            this.id = id;
            this.exclusions = exclusions;
        }

        private boolean excluded(String id) {
            if (this.exclusions == null || this.exclusions.isEmpty()) {
                return false;
            }
            String[] components = id.split(":");
            for (Exclusion exclusion : this.exclusions) {
                if (!this.matches(components[0], exclusion.getGroupId()) || !this.matches(components[1], exclusion.getArtifactId())) continue;
                return true;
            }
            return false;
        }

        private boolean matches(String candidate, String exclusion) {
            return exclusion.equals("*") || exclusion.equals(candidate);
        }
    }
}

