/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal;

import io.spring.gradle.dependencymanagement.internal.DependencyManagementContainer;
import io.spring.gradle.dependencymanagement.internal.Versions;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VersionConfiguringAction
implements Action<DependencyResolveDetails> {
    private static final Logger logger = LoggerFactory.getLogger(VersionConfiguringAction.class);
    private final Project project;
    private final DependencyManagementContainer dependencyManagementContainer;
    private final Configuration configuration;
    private final LocalProjects localProjects;
    private Set<String> directDependencies;

    VersionConfiguringAction(Project project, DependencyManagementContainer dependencyManagementContainer, Configuration configuration) {
        this.project = project;
        this.localProjects = project.getGradle().getStartParameter().isConfigureOnDemand() ? new StandardLocalProjects(project) : new CachingLocalProjects(project);
        this.dependencyManagementContainer = dependencyManagementContainer;
        this.configuration = configuration;
    }

    public void execute(DependencyResolveDetails details) {
        logger.debug("Processing dependency '{}'", (Object)details.getRequested());
        if (this.isDependencyOnLocalProject(this.project, details)) {
            logger.debug("'{}' is a local project dependency. Dependency management has not been applied", (Object)details.getRequested());
            return;
        }
        if (this.isDirectDependency(details) && Versions.isDynamic(details.getRequested().getVersion())) {
            logger.debug("'{}' is a direct dependency and has a dynamic version. Dependency management has not been applied", (Object)details.getRequested());
            return;
        }
        String version = this.dependencyManagementContainer.getManagedVersion(this.configuration, details.getRequested().getGroup(), details.getRequested().getName());
        if (version != null) {
            logger.debug("Using version '{}' for dependency '{}'", (Object)version, (Object)details.getRequested());
            details.useVersion(version);
            return;
        }
        logger.debug("No dependency management for dependency '{}'", (Object)details.getRequested());
    }

    private boolean isDirectDependency(DependencyResolveDetails details) {
        if (this.directDependencies == null) {
            HashSet<String> directDependencies = new HashSet<String>();
            for (Dependency dependency : this.configuration.getAllDependencies()) {
                directDependencies.add(dependency.getGroup() + ":" + dependency.getName());
            }
            this.directDependencies = directDependencies;
        }
        return this.directDependencies.contains(this.getId(details));
    }

    private boolean isDependencyOnLocalProject(Project project, DependencyResolveDetails details) {
        return this.localProjects.getNames().contains(this.getId(details));
    }

    private String getId(DependencyResolveDetails details) {
        return details.getRequested().getGroup() + ":" + details.getRequested().getName();
    }

    ResolutionStrategy applyTo(Configuration c) {
        return c.getResolutionStrategy().eachDependency((Action)this);
    }

    private static final class CachingLocalProjects
    implements LocalProjects {
        private final LocalProjects delegate;
        private Set<String> localProjectNames;

        private CachingLocalProjects(Project project) {
            this.delegate = new StandardLocalProjects(project);
        }

        @Override
        public Set<String> getNames() {
            Set<String> names = this.localProjectNames;
            if (names == null) {
                this.localProjectNames = names = this.delegate.getNames();
            }
            return names;
        }
    }

    private static final class StandardLocalProjects
    implements LocalProjects {
        private final Project project;

        private StandardLocalProjects(Project project) {
            this.project = project;
        }

        @Override
        public Set<String> getNames() {
            HashSet<String> names = new HashSet<String>();
            for (Project localProject : this.project.getRootProject().getAllprojects()) {
                names.add(localProject.getGroup() + ":" + localProject.getName());
            }
            return names;
        }
    }

    private static interface LocalProjects {
        public Set<String> getNames();
    }
}

