/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal;

import io.spring.gradle.dependencymanagement.internal.Exclusions;
import io.spring.gradle.dependencymanagement.internal.pom.Coordinates;
import io.spring.gradle.dependencymanagement.internal.pom.Dependency;
import io.spring.gradle.dependencymanagement.internal.pom.Pom;
import io.spring.gradle.dependencymanagement.internal.pom.PomReference;
import io.spring.gradle.dependencymanagement.internal.pom.PomResolver;
import io.spring.gradle.dependencymanagement.internal.properties.ProjectPropertySource;
import io.spring.gradle.dependencymanagement.internal.properties.PropertySource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyManagement {
    private static final Logger logger = LoggerFactory.getLogger(DependencyManagement.class);
    private final Project project;
    private final Configuration targetConfiguration;
    private final PomResolver pomResolver;
    private boolean resolved;
    private final Map<String, String> versions = new HashMap<String, String>();
    private final Map<String, String> explicitVersions = new HashMap<String, String>();
    private final Exclusions explicitExclusions = new Exclusions();
    private final Exclusions allExclusions = new Exclusions();
    private final Map<String, String> bomProperties = new HashMap<String, String>();
    private final List<PomReference> importedBoms = new ArrayList<PomReference>();
    private List<Pom> resolvedBoms = new ArrayList<Pom>();

    DependencyManagement(Project project, PomResolver pomResolver) {
        this(project, null, pomResolver);
    }

    DependencyManagement(Project project, Configuration targetConfiguration, PomResolver pomResolver) {
        this.project = project;
        this.pomResolver = pomResolver;
        this.targetConfiguration = targetConfiguration;
    }

    void importBom(Coordinates coordinates, PropertySource properties) {
        this.importedBoms.add(new PomReference(coordinates, properties));
    }

    List<Pom> getImportedBoms() {
        this.resolveIfNecessary();
        return this.resolvedBoms;
    }

    List<PomReference> getImportedBomReferences() {
        return this.importedBoms;
    }

    Map<String, String> getImportedProperties() {
        this.resolveIfNecessary();
        return this.bomProperties;
    }

    void addImplicitManagedVersion(String group, String name, String version) {
        this.versions.put(this.createKey(group, name), version);
    }

    void addExplicitManagedVersion(String group, String name, String version, List<String> exclusions) {
        String key = this.createKey(group, name);
        this.explicitVersions.put(key, version);
        this.explicitExclusions.add(key, exclusions);
        this.allExclusions.add(key, exclusions);
        this.addImplicitManagedVersion(group, name, version);
    }

    String getManagedVersion(String group, String name) {
        this.resolveIfNecessary();
        return this.versions.get(this.createKey(group, name));
    }

    Map<String, String> getManagedVersions() {
        this.resolveIfNecessary();
        return new HashMap<String, String>(this.versions);
    }

    public List<Dependency> getManagedDependencies() {
        ArrayList<Dependency> managedDependencies = new ArrayList<Dependency>();
        for (Map.Entry<String, String> entry : this.explicitVersions.entrySet()) {
            String[] components = entry.getKey().split(":");
            managedDependencies.add(new Dependency(new Coordinates(components[0], components[1], entry.getValue()), this.explicitExclusions.exclusionsForDependency(entry.getKey())));
        }
        return managedDependencies;
    }

    private String createKey(String group, String name) {
        return group + ":" + name;
    }

    Exclusions getExclusions() {
        this.resolveIfNecessary();
        return this.allExclusions;
    }

    private void resolveIfNecessary() {
        if (!this.importedBoms.isEmpty() && !this.resolved) {
            try {
                this.resolved = true;
                this.resolve();
            }
            catch (Exception ex) {
                throw new GradleException("Failed to resolve imported Maven boms: " + this.getRootCause(ex).getMessage(), (Throwable)ex);
            }
        }
    }

    private Throwable getRootCause(Exception ex) {
        Throwable candidate = ex;
        while (candidate.getCause() != null) {
            candidate = candidate.getCause();
        }
        return candidate;
    }

    private void resolve() {
        if (this.targetConfiguration != null) {
            logger.info("Resolving dependency management for configuration '{}' of project '{}'", (Object)this.targetConfiguration.getName(), (Object)this.project.getName());
        } else {
            logger.info("Resolving global dependency management for project '{}'", (Object)this.project.getName());
        }
        HashMap<String, String> existingVersions = new HashMap<String, String>();
        existingVersions.putAll(this.versions);
        logger.debug("Preserving existing versions: {}", existingVersions);
        this.resolvedBoms = this.pomResolver.resolvePoms(this.importedBoms, new ProjectPropertySource(this.project));
        for (Pom resolvedBom : this.resolvedBoms) {
            for (Dependency dependency : resolvedBom.getManagedDependencies()) {
                Coordinates coordinates = dependency.getCoordinates();
                this.versions.put(coordinates.getGroupId() + ":" + coordinates.getArtifactId(), coordinates.getVersion());
                this.allExclusions.add(coordinates.getGroupId() + ":" + coordinates.getArtifactId(), dependency.getExclusions());
            }
            this.bomProperties.putAll(resolvedBom.getProperties());
        }
        this.versions.putAll(existingVersions);
    }
}

