/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.sse.dtos;

import io.split.engine.sse.NotificationProcessor;
import io.split.engine.sse.dtos.GenericNotificationData;
import io.split.engine.sse.dtos.IncomingNotification;

public class SegmentChangeNotification
extends IncomingNotification {
    private final long changeNumber;
    private final String segmentName;

    public SegmentChangeNotification(GenericNotificationData genericNotificationData) {
        super(IncomingNotification.Type.SEGMENT_UPDATE, genericNotificationData.getChannel());
        this.changeNumber = genericNotificationData.getChangeNumber();
        this.segmentName = genericNotificationData.getSegmentName();
    }

    public String getSegmentName() {
        return this.segmentName;
    }

    public long getChangeNumber() {
        return this.changeNumber;
    }

    @Override
    public void handler(NotificationProcessor notificationProcessor) {
        notificationProcessor.processSegmentUpdate(this.getChangeNumber(), this.getSegmentName());
    }

    public String toString() {
        return String.format("Type: %s; Channel: %s; ChangeNumber: %s; SegmentName: %s", new Object[]{this.getType(), this.getChannel(), this.getChangeNumber(), this.getSegmentName()});
    }
}

