/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.lambda.cache;

import com.google.common.base.CaseFormat;
import com.netflix.spinnaker.clouddriver.cache.KeyParser;
import java.util.HashMap;
import java.util.Map;

public class Keys
implements KeyParser {
    public static final String SEPARATOR = ":";

    public String getCloudProvider() {
        return "aws";
    }

    public Map<String, String> parseKey(String key) {
        return Keys.parse(key);
    }

    public Boolean canParseType(String type) {
        return Keys.canParse(type);
    }

    private static Boolean canParse(String type) {
        for (Namespace key : Namespace.values()) {
            if (!key.toString().equals(type)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, String> parse(String key) {
        String[] parts = key.split(SEPARATOR);
        if (parts.length < 3 || !parts[0].equals("aws")) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("provider", parts[0]);
        result.put("type", parts[1]);
        result.put("account", parts[2]);
        Namespace namespace = Namespace.valueOf(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, parts[1]));
        switch (namespace) {
            case LAMBDA_FUNCTIONS: {
                result.put("region", parts[3]);
                result.put("AwsLambdaName", parts[4]);
                break;
            }
            case IAM_ROLE: {
                result.put("roleName", parts[3]);
                break;
            }
        }
        return result;
    }

    public Boolean canParseField(String type) {
        return false;
    }

    public static String getLambdaFunctionKey(String account, String region, String functionName) {
        return String.format("%s:%s:%s:%s:%s", new Object[]{"aws", Namespace.LAMBDA_FUNCTIONS, account, region, functionName});
    }

    public static String getIamRoleKey(String account, String iamRoleName) {
        return String.format("%s:%s:%s:%s", new Object[]{"aws", Namespace.IAM_ROLE, account, iamRoleName});
    }

    public static enum Namespace {
        IAM_ROLE,
        LAMBDA_FUNCTIONS;

        public final String ns = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());

        public String toString() {
            return this.ns;
        }
    }
}

