/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.dsl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.specto.hoverfly.junit.core.ObjectMapperFactory;
import io.specto.hoverfly.junit.dsl.SingleQuoteHttpBodyConverter;

public interface HttpBodyConverter {
    public static final ObjectMapper XML_MAPPER = new XmlMapper().registerModule((Module)new JavaTimeModule()).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_XML = "application/xml";

    public static HttpBodyConverter json(Object body) {
        return HttpBodyConverter.json(body, ObjectMapperFactory.getDefaultObjectMapper());
    }

    public static SingleQuoteHttpBodyConverter jsonWithSingleQuotes(String body) {
        return new SingleQuoteHttpBodyConverter(body);
    }

    public static HttpBodyConverter json(final Object body, final ObjectMapper objectMapper) {
        return new HttpBodyConverter(){

            @Override
            public String body() {
                return HttpBodyConverter.marshallJson(body, objectMapper);
            }

            @Override
            public String contentType() {
                return HttpBodyConverter.APPLICATION_JSON;
            }
        };
    }

    public static HttpBodyConverter xml(Object body) {
        return HttpBodyConverter.xml(body, XML_MAPPER);
    }

    public static HttpBodyConverter xml(final Object body, final ObjectMapper xmlMapper) {
        return new HttpBodyConverter(){

            @Override
            public String body() {
                return HttpBodyConverter.marshallJson(body, xmlMapper);
            }

            @Override
            public String contentType() {
                return HttpBodyConverter.APPLICATION_XML;
            }
        };
    }

    public static String marshallJson(Object body, ObjectMapper objectMapper) {
        try {
            return objectMapper.writeValueAsString(body);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Cannot marshall: " + body, e);
        }
    }

    public String body();

    public String contentType();
}

