/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import io.specto.hoverfly.junit.api.AuthHeaderInterceptor;
import io.specto.hoverfly.junit.api.HoverflyClient;
import io.specto.hoverfly.junit.api.HoverflyClientException;
import io.specto.hoverfly.junit.api.command.DestinationCommand;
import io.specto.hoverfly.junit.api.command.JournalIndexCommand;
import io.specto.hoverfly.junit.api.command.JournalSearchCommand;
import io.specto.hoverfly.junit.api.command.ModeCommand;
import io.specto.hoverfly.junit.api.command.SortParams;
import io.specto.hoverfly.junit.api.model.CsvDataSource;
import io.specto.hoverfly.junit.api.model.ModeArguments;
import io.specto.hoverfly.junit.api.model.PostServeAction;
import io.specto.hoverfly.junit.api.view.DiffView;
import io.specto.hoverfly.junit.api.view.HoverflyInfoView;
import io.specto.hoverfly.junit.api.view.JournalIndexView;
import io.specto.hoverfly.junit.api.view.PostServeActions;
import io.specto.hoverfly.junit.api.view.StateView;
import io.specto.hoverfly.junit.core.HoverflyMode;
import io.specto.hoverfly.junit.core.ObjectMapperFactory;
import io.specto.hoverfly.junit.core.model.Journal;
import io.specto.hoverfly.junit.core.model.Simulation;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OkHttpHoverflyClient
implements HoverflyClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(HoverflyClient.class);
    private static final String HEALTH_CHECK_PATH = "api/health";
    private static final String SIMULATION_PATH = "api/v2/simulation";
    private static final String INFO_PATH = "api/v2/hoverfly";
    private static final String DESTINATION_PATH = "api/v2/hoverfly/destination";
    private static final String MODE_PATH = "api/v2/hoverfly/mode";
    private static final String JOURNAL_PATH = "api/v2/journal";
    private static final String JOURNAL_INDEX_PATH = "api/v2/journal/index";
    private static final String CSV_DATA_SOURCE_PATH = "api/v2/hoverfly/templating-data-source/csv";
    private static final String POST_SERVE_ACTION_PATH = "api/v2/hoverfly/post-serve-action";
    private static final String STATE_PATH = "api/v2/state";
    private static final String DIFF_PATH = "api/v2/diff";
    private static final MediaType JSON = MediaType.parse((String)"application/json");
    private final OkHttpClient client;
    private final HttpUrl baseUrl;

    OkHttpHoverflyClient(String scheme, String host, int port, String authToken) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (authToken != null) {
            clientBuilder.addInterceptor((Interceptor)new AuthHeaderInterceptor(authToken));
        }
        this.client = clientBuilder.build();
        this.baseUrl = new HttpUrl.Builder().scheme(scheme).host(host).port(port).build();
    }

    OkHttpHoverflyClient(String scheme, String host, int port, OkHttpClient client) {
        this.client = client;
        this.baseUrl = new HttpUrl.Builder().scheme(scheme).host(host).port(port).build();
    }

    @Override
    public void setSimulation(Simulation simulation) {
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(SIMULATION_PATH, new String[0]);
            RequestBody body = this.createRequestBody(simulation);
            Request request = builder.put(body).build();
            this.exchange(request);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to set simulation: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to set simulation: " + e.getMessage());
        }
    }

    @Override
    public void setSimulation(String simulation) {
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(SIMULATION_PATH, new String[0]);
            RequestBody body = RequestBody.create((MediaType)JSON, (String)simulation);
            Request request = builder.put(body).build();
            this.exchange(request);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to set simulation: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to set simulation: " + e.getMessage());
        }
    }

    @Override
    public void addSimulation(Simulation simulation) {
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(SIMULATION_PATH, new String[0]);
            RequestBody body = this.createRequestBody(simulation);
            Request request = builder.post(body).build();
            this.exchange(request);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to add simulation: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to add simulation: " + e.getMessage());
        }
    }

    @Override
    public Simulation getSimulation() {
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(SIMULATION_PATH, new String[0]);
            Request request = builder.get().build();
            return this.exchange(request, Simulation.class);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to get simulation: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to get simulation: " + e.getMessage());
        }
    }

    @Override
    public JsonNode getSimulationJson() {
        JsonNode jsonNode;
        block8: {
            Request.Builder builder = this.createRequestBuilderWithUrl(SIMULATION_PATH, new String[0]);
            Request request = builder.get().build();
            Response response = this.client.newCall(request).execute();
            try {
                this.onFailure(response);
                jsonNode = ObjectMapperFactory.getDefaultObjectMapper().readTree(response.body().string());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to get simulation: {}", (Object)e.getMessage());
                    throw new HoverflyClientException("Failed to get simulation: " + e.getMessage());
                }
            }
            response.close();
        }
        return jsonNode;
    }

    @Override
    public void deleteSimulation() {
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(SIMULATION_PATH, new String[0]);
            Request request = builder.delete().build();
            this.exchange(request);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to delete simulation: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to delete simulation: " + e.getMessage());
        }
    }

    @Override
    public Journal getJournal(int offset, int limit) {
        return this.getJournalInternal(offset, limit, null);
    }

    @Override
    public Journal getJournal(int offset, int limit, SortParams sortParams) {
        return this.getJournalInternal(offset, limit, sortParams);
    }

    @Override
    public Journal searchJournal(io.specto.hoverfly.junit.core.model.Request requestMatcher) {
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(JOURNAL_PATH, new String[0]);
            RequestBody body = this.createRequestBody(new JournalSearchCommand(requestMatcher));
            Request request = builder.post(body).build();
            return this.exchange(request, Journal.class);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to search journal: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to search journal: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<JournalIndexView> getJournalIndex() {
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(JOURNAL_INDEX_PATH, new String[0]);
            Request request = builder.get().build();
            CollectionType journalIndexListType = ObjectMapperFactory.getDefaultObjectMapper().getTypeFactory().constructCollectionType(List.class, JournalIndexView.class);
            try (Response response = this.client.newCall(request).execute();){
                this.onFailure(response);
                String responseJson = response.body().string();
                if ("null".equals(responseJson)) {
                    List<JournalIndexView> list2 = Collections.emptyList();
                    return list2;
                }
                List list = (List)ObjectMapperFactory.getDefaultObjectMapper().readValue(responseJson, (JavaType)journalIndexListType);
                return list;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to get config information: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to get config information: " + e.getMessage());
        }
    }

    @Override
    public void addJournalIndex(JournalIndexCommand journalIndexCommand) {
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(JOURNAL_INDEX_PATH, new String[0]);
            RequestBody body = this.createRequestBody(journalIndexCommand);
            Request request = builder.post(body).build();
            this.exchange(request);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to add journal index: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to add journal index: " + e.getMessage());
        }
    }

    @Override
    public void deleteJournalIndex(String indexName) {
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(JOURNAL_INDEX_PATH, indexName);
            Request request = builder.delete().build();
            this.exchange(request);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to delete journal index: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to delete journal index: " + e.getMessage());
        }
    }

    @Override
    public void deleteJournal() {
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(JOURNAL_PATH, new String[0]);
            Request request = builder.delete().build();
            this.exchange(request);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to delete journal: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to delete journal: " + e.getMessage());
        }
    }

    @Override
    public List<CsvDataSource> getCsvDataSources() {
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(CSV_DATA_SOURCE_PATH, new String[0]);
            Request request = builder.get().build();
            Map<String, List<CsvDataSource>> response = this.exchange(request, new TypeReference<Map<String, List<CsvDataSource>>>(){});
            return response.getOrDefault("csvDataSources", Collections.emptyList());
        }
        catch (Exception e) {
            LOGGER.warn("Failed to get csv data source: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to get csv data source: " + e.getMessage());
        }
    }

    @Override
    public void addCsvDataSource(CsvDataSource dataSource) {
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(CSV_DATA_SOURCE_PATH, new String[0]);
            RequestBody body = this.createRequestBody(dataSource);
            Request request = builder.put(body).build();
            this.exchange(request);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to csv data source: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to add csv data source: " + e.getMessage());
        }
    }

    @Override
    public void deleteCsvDataSource(String name) {
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(CSV_DATA_SOURCE_PATH, name);
            Request request = builder.delete().build();
            this.exchange(request);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to delete csv data source: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to delete csv data source: " + e.getMessage());
        }
    }

    @Override
    public PostServeActions getPostServeActions() {
        try {
            Request request = this.createRequestBuilderWithUrl(POST_SERVE_ACTION_PATH, new String[0]).get().build();
            return this.exchange(request, PostServeActions.class);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to get post serve actions: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to get post serve actions: " + e.getMessage());
        }
    }

    @Override
    public void updatePostServeAction(PostServeAction postServeAction) {
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(POST_SERVE_ACTION_PATH, new String[0]);
            RequestBody body = this.createRequestBody(postServeAction);
            Request request = builder.put(body).build();
            this.exchange(request);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to update post serve actions: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to update post serve actions: " + e.getMessage());
        }
    }

    @Override
    public void deletePostServeAction(String actionName) {
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(POST_SERVE_ACTION_PATH, actionName);
            Request request = builder.delete().build();
            this.exchange(request);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to delete post serve actions: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to delete post serve actions: " + e.getMessage());
        }
    }

    @Override
    public void deleteState() {
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(STATE_PATH, new String[0]);
            Request request = builder.delete().build();
            this.exchange(request);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to delete states: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to delete states: " + e.getMessage());
        }
    }

    @Override
    public StateView getState() {
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(STATE_PATH, new String[0]);
            Request request = builder.get().build();
            return this.exchange(request, StateView.class);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to get state: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to get state: " + e.getMessage());
        }
    }

    @Override
    public DiffView getDiffs() {
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(DIFF_PATH, new String[0]);
            Request request = builder.get().build();
            return this.exchange(request, DiffView.class);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to get diffs: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to get diffs: " + e.getMessage());
        }
    }

    @Override
    public void setState(StateView stateView) {
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(STATE_PATH, new String[0]);
            RequestBody body = this.createRequestBody(stateView);
            Request request = builder.put(body).build();
            this.exchange(request);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to set states: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to set states: " + e.getMessage());
        }
    }

    @Override
    public void updateState(StateView stateView) {
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(STATE_PATH, new String[0]);
            RequestBody body = this.createRequestBody(stateView);
            Request request = builder.patch(body).build();
            this.exchange(request);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to update states: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to update states: " + e.getMessage());
        }
    }

    @Override
    public void cleanDiffs() {
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(DIFF_PATH, new String[0]);
            Request request = builder.delete().build();
            this.exchange(request);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to delete diffs: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to delete diffs: " + e.getMessage());
        }
    }

    @Override
    public HoverflyInfoView getConfigInfo() {
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(INFO_PATH, new String[0]);
            Request request = builder.get().build();
            return this.exchange(request, HoverflyInfoView.class);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to get config information: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to get config information: " + e.getMessage());
        }
    }

    @Override
    public void setDestination(String destination) {
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(DESTINATION_PATH, new String[0]);
            RequestBody body = this.createRequestBody(new DestinationCommand(destination));
            Request request = builder.put(body).build();
            this.exchange(request);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to set destination: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to set destination: " + e.getMessage());
        }
    }

    @Override
    public void setMode(HoverflyMode mode) {
        this.putModeRequest(new ModeCommand(mode));
    }

    @Override
    public void setMode(HoverflyMode mode, ModeArguments modeArguments) {
        this.putModeRequest(new ModeCommand(mode, modeArguments));
    }

    @Override
    public boolean getHealth() {
        boolean isHealthy = false;
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(HEALTH_CHECK_PATH, new String[0]);
            Request request = builder.get().build();
            this.exchange(request);
            isHealthy = true;
        }
        catch (Exception e) {
            LOGGER.debug("Hoverfly healthcheck failed: " + e.getMessage());
        }
        return isHealthy;
    }

    private Journal getJournalInternal(int offset, int limit, SortParams sortParams) {
        try {
            HttpUrl.Builder urlBuilder = this.baseUrl.newBuilder().addPathSegments(JOURNAL_PATH).addQueryParameter("offset", String.valueOf(offset)).addQueryParameter("limit", String.valueOf(limit));
            if (sortParams != null) {
                urlBuilder.addQueryParameter("sort", sortParams.toString());
            }
            Request.Builder builder = new Request.Builder().url(urlBuilder.build());
            Request request = builder.get().build();
            return this.exchange(request, Journal.class);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to get journal: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to get journal: " + e.getMessage());
        }
    }

    private void putModeRequest(ModeCommand modeCommand) {
        try {
            RequestBody body = this.createRequestBody(modeCommand);
            Request.Builder builder = this.createRequestBuilderWithUrl(MODE_PATH, new String[0]);
            Request request = builder.put(body).build();
            this.exchange(request);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to set mode: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to set mode: " + e.getMessage());
        }
    }

    private Request.Builder createRequestBuilderWithUrl(String path, String ... pathSegments) {
        HttpUrl.Builder urlBuilder = this.baseUrl.newBuilder().addPathSegments(path);
        Arrays.stream(pathSegments).forEach(arg_0 -> ((HttpUrl.Builder)urlBuilder).addPathSegment(arg_0));
        return new Request.Builder().url(urlBuilder.build());
    }

    private RequestBody createRequestBody(Object data) throws JsonProcessingException {
        String content = ObjectMapperFactory.getDefaultObjectMapper().writeValueAsString(data);
        return RequestBody.create((MediaType)JSON, (String)content);
    }

    private <T> T exchange(Request request, Class<T> clazz) throws IOException {
        try (Response response = this.client.newCall(request).execute();){
            this.onFailure(response);
            Object object = ObjectMapperFactory.getDefaultObjectMapper().readValue(response.body().string(), clazz);
            return (T)object;
        }
    }

    private <T> T exchange(Request request, TypeReference<T> clazz) throws IOException {
        try (Response response = this.client.newCall(request).execute();){
            this.onFailure(response);
            Object object = ObjectMapperFactory.getDefaultObjectMapper().readValue(response.body().string(), clazz);
            return (T)object;
        }
    }

    private void exchange(Request request) throws IOException {
        try (Response response = this.client.newCall(request).execute();){
            this.onFailure(response);
        }
    }

    private void onFailure(Response response) throws IOException {
        if (!response.isSuccessful()) {
            String errorResponse = String.format("Unexpected response (code=%d, message=%s)", response.code(), response.body().string());
            throw new IOException(errorResponse);
        }
    }
}

