/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.dsl.matchers;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import io.specto.hoverfly.junit.core.ObjectMapperFactory;
import io.specto.hoverfly.junit.core.model.RequestFieldMatcher;
import io.specto.hoverfly.junit.dsl.HoverflyDslException;
import io.specto.hoverfly.junit.dsl.HttpBodyConverter;
import java.io.IOException;

public class HoverflyMatchers {
    private static final XmlMapper XML_MAPPER = new XmlMapper();

    private HoverflyMatchers() {
    }

    public static RequestFieldMatcher<String> equalsTo(Object value) {
        return RequestFieldMatcher.newExactMatcher(value.toString());
    }

    public static RequestFieldMatcher<String> matches(String value) {
        return RequestFieldMatcher.newGlobMatcher(value);
    }

    public static RequestFieldMatcher<String> matchesGoRegex(String regexPattern) {
        return RequestFieldMatcher.newRegexMatcher(regexPattern);
    }

    public static RequestFieldMatcher<String> startsWith(String value) {
        return RequestFieldMatcher.newRegexMatcher(String.format("^%s.*", value));
    }

    public static RequestFieldMatcher<String> endsWith(String value) {
        return RequestFieldMatcher.newRegexMatcher(String.format(".*%s$", value));
    }

    public static RequestFieldMatcher<String> contains(String value) {
        return RequestFieldMatcher.newRegexMatcher(String.format(".*%s.*", value));
    }

    public static RequestFieldMatcher<String> any() {
        return RequestFieldMatcher.newRegexMatcher(".*");
    }

    public static RequestFieldMatcher<String> equalsToJson(String value) {
        HoverflyMatchers.validateJson(value);
        return RequestFieldMatcher.newJsonMatcher(value);
    }

    public static RequestFieldMatcher<String> equalsToJson(HttpBodyConverter converter) {
        return HoverflyMatchers.equalsToJson(converter.body());
    }

    public static RequestFieldMatcher<String> matchesPartialJson(String value) {
        HoverflyMatchers.validateJson(value);
        return RequestFieldMatcher.newJsonPartialMatcher(value);
    }

    public static RequestFieldMatcher<String> matchesPartialJson(HttpBodyConverter converter) {
        return HoverflyMatchers.matchesPartialJson(converter.body());
    }

    public static RequestFieldMatcher<String> matchesJsonPath(String expression) {
        return RequestFieldMatcher.newJsonPathMatch(expression);
    }

    public static RequestFieldMatcher<String> equalsToXml(String value) {
        HoverflyMatchers.validateXml(value);
        return RequestFieldMatcher.newXmlMatcher(value);
    }

    public static RequestFieldMatcher<String> equalsToXml(HttpBodyConverter converter) {
        return HoverflyMatchers.equalsToXml(converter.body());
    }

    public static RequestFieldMatcher<String> matchesXPath(String expression) {
        return RequestFieldMatcher.newXpathMatcher(expression);
    }

    private static void validateJson(String value) {
        try {
            ObjectMapperFactory.getDefaultObjectMapper().readTree(value);
        }
        catch (IOException e) {
            throw new HoverflyDslException("Fail to create JSON matcher from invalid JSON string: " + value);
        }
    }

    private static void validateXml(String value) {
        try {
            XML_MAPPER.readTree(value);
        }
        catch (IOException e) {
            throw new HoverflyDslException("Fail to create XML matcher from invalid XML string: " + value);
        }
    }
}

