/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.util;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;

class KotlinUtil {
    private KotlinUtil() {
    }

    private static String getGetterName(FieldInfo field) {
        String fieldName = field.name();
        return "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    private static String getSyntheticPropertyAnnotationsMethodName(FieldInfo field) {
        return KotlinUtil.getGetterName(field) + "$annotations";
    }

    private static Optional<MethodInfo> getSyntheticPropertyAnnotationsMethod(FieldInfo field) {
        String methodName = KotlinUtil.getSyntheticPropertyAnnotationsMethodName(field);
        ClassInfo clazz = field.declaringClass();
        return clazz.methods().stream().filter(m -> m.isSynthetic() && methodName.equals(m.name())).findFirst();
    }

    static List<AnnotationInstance> getPropertyAnnotations(FieldInfo field) {
        return KotlinUtil.getSyntheticPropertyAnnotationsMethod(field).stream().flatMap(methodInfo -> methodInfo.annotations().stream().filter(a -> methodInfo.equals((Object)a.target())).map(a -> AnnotationInstance.create((DotName)a.name(), (boolean)a.runtimeVisible(), (AnnotationTarget)field, (List)a.values()))).collect(Collectors.toList());
    }
}

