package io.smallrye.openapi.api.util;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Class;
import java.lang.String;
import org.jboss.logging.Logger;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class UtilLogging_$logger extends DelegatingBasicLogger implements UtilLogging, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = UtilLogging_$logger.class.getName();
    public UtilLogging_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void failedToIntrospectBeanInfo(final Class<?> clazz, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, failedToIntrospectBeanInfo$str(), clazz);
    }
    protected String failedToIntrospectBeanInfo$str() {
        return "SROAP01000: Failed to introspect BeanInfo for: %s";
    }
    @Override
    public final void unusedSchemaRemoved(final String name) {
        super.log.logf(FQCN, INFO, null, unusedSchemaRemoved$str(), name);
    }
    protected String unusedSchemaRemoved$str() {
        return "SROAP01001: Schema with zero references removed from #/components/schemas: %s";
    }
    @Override
    public final void cylicReferenceDetected() {
        super.log.logf(FQCN, INFO, null, cylicReferenceDetected$str());
    }
    protected String cylicReferenceDetected$str() {
        return "SROAP01002: Cyclic object reference detected in OpenAPI model, skipping current node";
    }
    @Override
    public final void cylicReferenceAvoided(final String propertyName, final String typeName) {
        super.log.logf(FQCN, WARN, null, cylicReferenceAvoided$str(), propertyName, typeName);
    }
    protected String cylicReferenceAvoided$str() {
        return "SROAP01003: Merge of property would result in cyclic object reference in OpenAPI model, skipping property '%s' in type %s";
    }
}
