/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.content;

import com.fasterxml.jackson.databind.JsonNode;
import io.smallrye.openapi.api.constants.OpenApiConstants;
import io.smallrye.openapi.api.models.media.ContentImpl;
import io.smallrye.openapi.runtime.io.ContentDirection;
import io.smallrye.openapi.runtime.io.CurrentScannerInfo;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.mediatype.MediaTypeReader;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.Annotations;
import java.util.Iterator;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class ContentReader {
    private ContentReader() {
    }

    public static Content readContent(AnnotationScannerContext context, AnnotationValue annotationValue, ContentDirection direction) {
        AnnotationInstance[] nestedArray;
        if (annotationValue == null) {
            return null;
        }
        IoLogging.logger.singleAnnotation("@Content");
        ContentImpl content = new ContentImpl();
        for (AnnotationInstance nested : nestedArray = annotationValue.asNestedArray()) {
            String contentType = (String)Annotations.value(nested, "mediaType");
            MediaType mediaTypeModel = MediaTypeReader.readMediaType(context, nested);
            if (contentType == null) {
                for (String mimeType : ContentReader.getDefaultMimeTypes(direction)) {
                    content.addMediaType(mimeType, mediaTypeModel);
                }
                continue;
            }
            content.addMediaType(contentType, mediaTypeModel);
        }
        return content;
    }

    public static Content readContent(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        ContentImpl content = new ContentImpl();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            content.addMediaType(fieldName, MediaTypeReader.readMediaType(node.get(fieldName)));
        }
        return content;
    }

    private static String[] getDefaultMimeTypes(ContentDirection direction) {
        if (direction == ContentDirection.INPUT && CurrentScannerInfo.getCurrentConsumes() != null) {
            return CurrentScannerInfo.getCurrentConsumes();
        }
        if (direction == ContentDirection.OUTPUT && CurrentScannerInfo.getCurrentProduces() != null) {
            return CurrentScannerInfo.getCurrentProduces();
        }
        if (direction == ContentDirection.PARAMETER) {
            return OpenApiConstants.DEFAULT_MEDIA_TYPES.get();
        }
        return new String[0];
    }
}

