/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.transformation;

import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.transformation.Transformer;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberTransformer
implements Transformer<Number, Number> {
    private final String typeClassName;

    protected NumberTransformer(Field field) {
        this(field.getReference().getClassName());
    }

    public NumberTransformer(String targetClassName) {
        this.typeClassName = targetClassName;
    }

    @Override
    public Number in(Number input) {
        if (this.typeClassName.equals(Integer.TYPE.getName()) || this.typeClassName.equals(Integer.class.getName())) {
            return input.intValue();
        }
        if (this.typeClassName.equals(Short.TYPE.getName()) || this.typeClassName.equals(Short.class.getName())) {
            return (short)input.intValue();
        }
        if (this.typeClassName.equals(Byte.TYPE.getName()) || this.typeClassName.equals(Byte.class.getName())) {
            return (byte)input.intValue();
        }
        if (this.typeClassName.equals(Float.TYPE.getName())) {
            return Float.valueOf(input.floatValue());
        }
        if (this.typeClassName.equals(Float.class.getName())) {
            return Float.valueOf(input.floatValue());
        }
        if (this.typeClassName.equals(Double.TYPE.getName())) {
            return input.doubleValue();
        }
        if (this.typeClassName.equals(Double.class.getName())) {
            return input.doubleValue();
        }
        if (this.typeClassName.equals(BigInteger.class.getName())) {
            if (input instanceof BigDecimal) {
                return ((BigDecimal)input).toBigInteger();
            }
            if (input instanceof BigInteger) {
                return input;
            }
            return BigInteger.valueOf(input.longValue());
        }
        if (this.typeClassName.equals(Long.TYPE.getName())) {
            return input.longValue();
        }
        if (this.typeClassName.equals(Long.class.getName())) {
            return input.longValue();
        }
        if (this.typeClassName.equals(BigDecimal.class.getName())) {
            if (input instanceof BigDecimal) {
                return input;
            }
            if (input instanceof BigInteger) {
                return new BigDecimal((BigInteger)input);
            }
            return BigDecimal.valueOf(input.doubleValue());
        }
        throw SmallRyeGraphQLServerMessages.msg.notAValidNumberType(this.typeClassName);
    }

    @Override
    public Number out(Number object) {
        return object;
    }
}

