/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.event;

import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.execution.event.InvokeInfo;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.spi.EventingService;
import io.smallrye.graphql.spi.config.Config;
import jakarta.annotation.Priority;
import jakarta.json.bind.Jsonb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.jboss.logging.Logger;

public class EventEmitter {
    private static final Logger LOG = Logger.getLogger(EventEmitter.class);
    private static final EventEmitter INSTANCE = new EventEmitter();
    private final List<EventingService> enabledServices;

    public static EventEmitter getInstance() {
        return INSTANCE;
    }

    private EventEmitter() {
        Config config = Config.get();
        ServiceLoader<EventingService> eventingServices = ServiceLoader.load(EventingService.class);
        Iterator<EventingService> it = eventingServices.iterator();
        ArrayList<EventingService> enabledServices = new ArrayList<EventingService>();
        while (it.hasNext()) {
            try {
                EventingService eventingService = it.next();
                String configKey = eventingService.getConfigKey();
                boolean enabled = configKey != null ? config.getConfigValue(configKey, Boolean.TYPE, false) : true;
                if (!enabled) continue;
                enabledServices.add(eventingService);
            }
            catch (Throwable t) {
                Throwable cause = t.getCause();
                LOG.warn((Object)("Failed to register " + t.getMessage() + (String)(cause != null ? "\n\tCaused by: " + cause.toString() : "")));
            }
        }
        enabledServices.sort(Comparator.comparing(this::getPriority));
        this.enabledServices = Collections.unmodifiableList(enabledServices);
    }

    private int getPriority(EventingService es) {
        Priority priority = es.getClass().getAnnotation(Priority.class);
        if (priority == null) {
            return 1000;
        }
        return priority.value();
    }

    public void fireBeforeExecute(Context context) {
        for (EventingService extensionService : this.enabledServices) {
            extensionService.beforeExecute(context);
        }
    }

    public void fireOnExecuteError(Context context, Throwable t) {
        for (EventingService extensionService : this.enabledServices) {
            extensionService.errorExecute(context, t);
        }
    }

    public void fireAfterExecute(Context context) {
        for (int i = this.enabledServices.size() - 1; i > -1; --i) {
            EventingService extensionService = this.enabledServices.get(i);
            extensionService.afterExecute(context);
        }
    }

    public void fireBeforeDataFetch(Context context) {
        for (EventingService extensionService : this.enabledServices) {
            extensionService.beforeDataFetch(context);
        }
    }

    public void fireBeforeMethodInvoke(InvokeInfo invokeInfo) throws Exception {
        for (EventingService extensionService : this.enabledServices) {
            extensionService.beforeInvoke(invokeInfo);
        }
    }

    public void fireOnDataFetchError(Context context, Throwable t) {
        for (EventingService extensionService : this.enabledServices) {
            extensionService.errorDataFetch(context, t);
        }
    }

    public void fireAfterDataFetch(Context context) {
        for (int i = this.enabledServices.size() - 1; i > -1; --i) {
            EventingService extensionService = this.enabledServices.get(i);
            extensionService.afterDataFetch(context);
        }
    }

    public GraphQL.Builder fireBeforeGraphQLBuild(GraphQL.Builder builder) {
        for (EventingService extensionService : this.enabledServices) {
            builder = extensionService.beforeGraphQLBuild(builder);
        }
        return builder;
    }

    public GraphQLSchema.Builder fireBeforeSchemaBuild(GraphQLSchema.Builder builder) {
        for (EventingService extensionService : this.enabledServices) {
            builder = extensionService.beforeSchemaBuild(builder);
        }
        return builder;
    }

    public Operation fireCreateOperation(Operation operation) {
        for (EventingService extensionService : this.enabledServices) {
            operation = extensionService.createOperation(operation);
        }
        return operation;
    }

    public Map<String, Jsonb> fireOverrideJsonbConfig() {
        HashMap<String, Jsonb> overrides = new HashMap<String, Jsonb>();
        for (EventingService extensionService : this.enabledServices) {
            Map<String, Jsonb> map = extensionService.overrideJsonbConfig();
            map.forEach((clazz, jsonb) -> {
                LOG.debug((Object)("Registering custom JsonB config for class " + clazz + " (it was returned by " + extensionService.getClass().getName() + ")"));
                overrides.put((String)clazz, (Jsonb)jsonb);
            });
        }
        return overrides;
    }
}

