/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQL;
import graphql.GraphQLError;
import graphql.GraphqlErrorBuilder;
import graphql.analysis.MaxQueryComplexityInstrumentation;
import graphql.analysis.MaxQueryDepthInstrumentation;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionStrategy;
import graphql.execution.SubscriptionExecutionStrategy;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.parser.ParserOptions;
import graphql.schema.GraphQLSchema;
import io.smallrye.graphql.SmallRyeGraphQLServerLogging;
import io.smallrye.graphql.bootstrap.DataFetcherFactory;
import io.smallrye.graphql.execution.ExecutionResponse;
import io.smallrye.graphql.execution.ExecutionResponseWriter;
import io.smallrye.graphql.execution.JsonObjectResponseWriter;
import io.smallrye.graphql.execution.QueryCache;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.execution.context.SmallRyeContextManager;
import io.smallrye.graphql.execution.datafetcher.helper.BatchLoaderHelper;
import io.smallrye.graphql.execution.error.ExceptionHandler;
import io.smallrye.graphql.execution.error.UnparseableDocumentException;
import io.smallrye.graphql.execution.event.EventEmitter;
import io.smallrye.graphql.execution.metrics.MetricsEmitter;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Schema;
import io.smallrye.graphql.schema.model.Type;
import io.smallrye.graphql.spi.config.Config;
import io.smallrye.graphql.spi.config.LogPayloadOption;
import io.smallrye.mutiny.Uni;
import jakarta.json.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.dataloader.BatchLoaderWithContext;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderFactory;
import org.dataloader.DataLoaderRegistry;

public class ExecutionService {
    private final String executionIdPrefix;
    private final AtomicLong executionId = new AtomicLong();
    private final GraphQLSchema graphQLSchema;
    private final BatchLoaderHelper batchLoaderHelper = new BatchLoaderHelper();
    private final DataFetcherFactory dataFetcherFactory = new DataFetcherFactory();
    private final Schema schema;
    private final EventEmitter eventEmitter = EventEmitter.getInstance();
    private final MetricsEmitter metricsEmitter = MetricsEmitter.getInstance();
    private GraphQL graphQL;
    private final QueryCache queryCache;
    private final LogPayloadOption payloadOption;
    private final ExecutionStrategy queryExecutionStrategy;
    private final ExecutionStrategy mutationExecutionStrategy;

    public ExecutionService(GraphQLSchema graphQLSchema, Schema schema) {
        this(graphQLSchema, schema, null, null);
    }

    public ExecutionService(GraphQLSchema graphQLSchema, Schema schema, ExecutionStrategy queryExecutionStrategy, ExecutionStrategy mutationExecutionStrategy) {
        this.graphQLSchema = graphQLSchema;
        this.schema = schema;
        this.executionIdPrefix = Integer.toString(Objects.hashCode(graphQLSchema));
        this.queryCache = new QueryCache();
        this.queryExecutionStrategy = queryExecutionStrategy;
        this.mutationExecutionStrategy = mutationExecutionStrategy;
        Config config = Config.get();
        this.payloadOption = config.logPayload();
    }

    @Deprecated
    public ExecutionResponse execute(JsonObject jsonInput) {
        try {
            JsonObjectResponseWriter jsonObjectResponseWriter = new JsonObjectResponseWriter(jsonInput);
            this.executeSync(jsonInput, jsonObjectResponseWriter);
            return jsonObjectResponseWriter.getExecutionResponse();
        }
        catch (Throwable t) {
            if (t.getClass().isAssignableFrom(RuntimeException.class)) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public void executeSync(JsonObject jsonInput, ExecutionResponseWriter writer) {
        this.executeSync(jsonInput, new HashMap<String, Object>(), writer);
    }

    public void executeSync(JsonObject jsonInput, Map<String, Object> context, ExecutionResponseWriter writer) {
        this.execute(jsonInput, context, writer, false);
    }

    public void executeAsync(JsonObject jsonInput, ExecutionResponseWriter writer) {
        this.executeAsync(jsonInput, new HashMap<String, Object>(), writer);
    }

    public void executeAsync(JsonObject jsonInput, Map<String, Object> context, ExecutionResponseWriter writer) {
        this.execute(jsonInput, context, writer, true);
    }

    public void execute(JsonObject jsonInput, ExecutionResponseWriter writer, boolean async) {
        this.execute(jsonInput, new HashMap<String, Object>(), writer, async);
    }

    public void execute(JsonObject jsonInput, Map<String, Object> context, ExecutionResponseWriter writer, boolean async) {
        block12: {
            SmallRyeContext smallRyeContext = SmallRyeContextManager.fromInitialRequest(jsonInput);
            ExecutionId finalExecutionId = ExecutionId.from((String)(this.executionIdPrefix + this.executionId.getAndIncrement()));
            try {
                String query = smallRyeContext.getQuery();
                Optional variables = smallRyeContext.getVariables();
                if (query == null || query.isEmpty()) {
                    ExecutionService.sendError("Missing 'query' field in the request", writer);
                    return;
                }
                if (this.payloadOption.equals((Object)LogPayloadOption.queryOnly)) {
                    SmallRyeGraphQLServerLogging.log.payloadIn(query);
                } else if (this.payloadOption.equals((Object)LogPayloadOption.queryAndVariables)) {
                    SmallRyeGraphQLServerLogging.log.payloadIn(query);
                    SmallRyeGraphQLServerLogging.log.payloadIn(variables.toString());
                }
                GraphQL g = this.getGraphQL();
                if (g != null) {
                    ExecutionInput.Builder executionBuilder = ExecutionInput.newExecutionInput().query(query).locale(this.resolveLocale(context)).executionId(finalExecutionId);
                    smallRyeContext.getVariables().ifPresent(arg_0 -> ((ExecutionInput.Builder)executionBuilder).variables(arg_0));
                    smallRyeContext.getOperationName().ifPresent(arg_0 -> ((ExecutionInput.Builder)executionBuilder).operationName(arg_0));
                    List batchOperations = this.schema.getBatchOperations();
                    if (batchOperations != null && !batchOperations.isEmpty()) {
                        DataLoaderRegistry dataLoaderRegistry = this.getDataLoaderRegistry(batchOperations);
                        executionBuilder.dataLoaderRegistry(dataLoaderRegistry);
                    }
                    ExecutionInput executionInput = executionBuilder.build();
                    try {
                        smallRyeContext = SmallRyeContextManager.populateFromExecutionInput(executionInput, this.queryCache);
                    }
                    catch (UnparseableDocumentException ex) {
                        ExecutionService.sendError("Unparseable input document", writer);
                        return;
                    }
                    context.put("context", smallRyeContext);
                    executionInput.getGraphQLContext().putAll(context);
                    this.eventEmitter.fireBeforeExecute(smallRyeContext);
                    if (async) {
                        this.writeAsync(g, executionInput, smallRyeContext, writer);
                    } else {
                        this.writeSync(g, executionInput, smallRyeContext, writer);
                    }
                    break block12;
                }
                SmallRyeGraphQLServerLogging.log.noGraphQLMethodsFound();
            }
            catch (Throwable t) {
                this.eventEmitter.fireOnExecuteError(smallRyeContext, t);
                writer.fail(t);
            }
        }
    }

    private Locale resolveLocale(Map<String, Object> context) {
        Object mayLocale = context.get("locale");
        if (mayLocale instanceof Locale) {
            return (Locale)mayLocale;
        }
        return Locale.getDefault();
    }

    private static void sendError(String errorMessage, ExecutionResponseWriter writer) {
        GraphQLError error = GraphqlErrorBuilder.newError().message(errorMessage, new Object[0]).build();
        ExecutionResult executionResult = ExecutionResultImpl.newExecutionResult().addError(error).build();
        ExecutionResponse executionResponse = new ExecutionResponse(executionResult);
        writer.write(executionResponse);
    }

    private void writeAsync(GraphQL graphQL, ExecutionInput executionInput, SmallRyeContext smallRyeContext, ExecutionResponseWriter writer) {
        Uni.createFrom().completionStage(() -> graphQL.executeAsync(executionInput)).subscribe().with(executionResult -> {
            SmallRyeContextManager.restore(smallRyeContext);
            this.notifyAndWrite(smallRyeContext, (ExecutionResult)executionResult, writer);
        }, failure -> {
            if (failure != null) {
                writer.fail((Throwable)failure);
            }
        });
    }

    private void writeSync(GraphQL g, ExecutionInput executionInput, SmallRyeContext smallRyeContext, ExecutionResponseWriter writer) {
        try {
            ExecutionResult executionResult = g.execute(executionInput);
            this.notifyAndWrite(smallRyeContext, executionResult, writer);
        }
        catch (Throwable t) {
            writer.fail(t);
        }
    }

    private void notifyAndWrite(SmallRyeContext smallRyeContext, ExecutionResult executionResult, ExecutionResponseWriter writer) {
        smallRyeContext.setExecutionResult(executionResult);
        this.eventEmitter.fireAfterExecute(smallRyeContext);
        ExecutionResponse executionResponse = new ExecutionResponse(executionResult, smallRyeContext.getAddedExtensions());
        if (!this.payloadOption.equals((Object)LogPayloadOption.off)) {
            SmallRyeGraphQLServerLogging.log.payloadOut(executionResponse.toString());
        }
        writer.write(executionResponse);
    }

    private <K, T> DataLoaderRegistry getDataLoaderRegistry(List<Operation> operations) {
        DataLoaderRegistry dataLoaderRegistry = new DataLoaderRegistry();
        for (Operation operation : operations) {
            Map types = this.schema.getTypes();
            BatchLoaderWithContext batchLoader = this.dataFetcherFactory.getSourceBatchLoader(operation, (Type)types.get(operation.getName()));
            DataLoader dataLoader = DataLoaderFactory.newDataLoader(batchLoader);
            dataLoaderRegistry.register(this.batchLoaderHelper.getName(operation), dataLoader);
        }
        return dataLoaderRegistry;
    }

    private GraphQL getGraphQL() {
        if (this.graphQL == null) {
            if (this.graphQLSchema != null) {
                Config config = Config.get();
                this.setParserOptions(config);
                GraphQL.Builder graphqlBuilder = GraphQL.newGraphQL((GraphQLSchema)this.graphQLSchema);
                graphqlBuilder = graphqlBuilder.defaultDataFetcherExceptionHandler((DataFetcherExceptionHandler)new ExceptionHandler());
                ArrayList<Object> chainedList = new ArrayList<Object>();
                if (config.getQueryComplexityInstrumentation().isPresent()) {
                    chainedList.add(new MaxQueryComplexityInstrumentation(config.getQueryComplexityInstrumentation().get().intValue()));
                }
                if (config.getQueryDepthInstrumentation().isPresent()) {
                    chainedList.add(new MaxQueryDepthInstrumentation(config.getQueryDepthInstrumentation().get().intValue()));
                }
                chainedList.add((Object)this.queryCache);
                graphqlBuilder = graphqlBuilder.instrumentation((Instrumentation)new ChainedInstrumentation(chainedList));
                graphqlBuilder = graphqlBuilder.preparsedDocumentProvider((PreparsedDocumentProvider)this.queryCache);
                if (this.queryExecutionStrategy != null) {
                    graphqlBuilder = graphqlBuilder.queryExecutionStrategy(this.queryExecutionStrategy);
                }
                if (this.mutationExecutionStrategy != null) {
                    graphqlBuilder = graphqlBuilder.mutationExecutionStrategy(this.mutationExecutionStrategy);
                }
                if (this.schema.hasSubscriptions()) {
                    graphqlBuilder = graphqlBuilder.subscriptionExecutionStrategy((ExecutionStrategy)new SubscriptionExecutionStrategy((DataFetcherExceptionHandler)new ExceptionHandler()));
                }
                graphqlBuilder = this.eventEmitter.fireBeforeGraphQLBuild(graphqlBuilder);
                this.graphQL = graphqlBuilder.build();
            } else {
                SmallRyeGraphQLServerLogging.log.noGraphQLMethodsFound();
            }
        }
        return this.graphQL;
    }

    private void setParserOptions(Config config) {
        if (config.hasParserOptions()) {
            ParserOptions.Builder parserOptionsBuilder = ParserOptions.newParserOptions();
            if (config.isParserCaptureIgnoredChars().isPresent()) {
                parserOptionsBuilder = parserOptionsBuilder.captureIgnoredChars(config.isParserCaptureIgnoredChars().get().booleanValue());
            }
            if (config.isParserCaptureLineComments().isPresent()) {
                parserOptionsBuilder = parserOptionsBuilder.captureLineComments(config.isParserCaptureLineComments().get().booleanValue());
            }
            if (config.isParserCaptureSourceLocation().isPresent()) {
                parserOptionsBuilder = parserOptionsBuilder.captureSourceLocation(config.isParserCaptureSourceLocation().get().booleanValue());
            }
            if (config.getParserMaxTokens().isPresent()) {
                parserOptionsBuilder = parserOptionsBuilder.maxTokens(config.getParserMaxTokens().get().intValue());
            }
            if (config.getParserMaxWhitespaceTokens().isPresent()) {
                parserOptionsBuilder = parserOptionsBuilder.maxWhitespaceTokens(config.getParserMaxWhitespaceTokens().get().intValue());
            }
            ParserOptions.setDefaultParserOptions((ParserOptions)parserOptionsBuilder.build());
        }
    }
}

