/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.transformation;

import io.smallrye.graphql.execution.Classes;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Transformation;
import io.smallrye.graphql.transformation.CalendarTransformer;
import io.smallrye.graphql.transformation.CharTransformer;
import io.smallrye.graphql.transformation.DateTransformer;
import io.smallrye.graphql.transformation.DurationTransformer;
import io.smallrye.graphql.transformation.FormattedNumberTransformer;
import io.smallrye.graphql.transformation.LegacyDateTransformer;
import io.smallrye.graphql.transformation.NumberTransformer;
import io.smallrye.graphql.transformation.PeriodTransformer;
import io.smallrye.graphql.transformation.UriTransformer;
import io.smallrye.graphql.transformation.UrlTransformer;
import io.smallrye.graphql.transformation.UuidTransformer;
import java.util.Calendar;
import java.util.GregorianCalendar;

public interface Transformer<IN, OUT> {
    public static final UuidTransformer UUID_TRANSFORMER = new UuidTransformer();
    public static final UrlTransformer URL_TRANSFORMER = new UrlTransformer();
    public static final UriTransformer URI_TRANSFORMER = new UriTransformer();
    public static final PeriodTransformer PERIOD_TRANSFORMER = new PeriodTransformer();
    public static final DurationTransformer DURATION_TRANSFORMER = new DurationTransformer();
    public static final CharTransformer CHAR_TRANSFORMER = new CharTransformer();

    public static Transformer transformer(Field field) {
        if (field.hasTransformation()) {
            Transformation format = field.getTransformation();
            if (format.getType().equals((Object)Transformation.Type.NUMBER)) {
                return new FormattedNumberTransformer(field);
            }
            if (format.getType().equals((Object)Transformation.Type.DATE)) {
                return Transformer.dateTransformer(field);
            }
        } else {
            if (Classes.isDateLikeType(field.getReference().getClassName())) {
                return Transformer.dateTransformer(field);
            }
            if (Classes.isNumberLikeType(field.getReference().getClassName())) {
                return new NumberTransformer(field);
            }
            if (Classes.isCharacter(field.getReference().getClassName())) {
                return CHAR_TRANSFORMER;
            }
            if (Classes.isUUID(field.getReference().getClassName())) {
                return UUID_TRANSFORMER;
            }
            if (Classes.isURL(field.getReference().getClassName())) {
                return URL_TRANSFORMER;
            }
            if (Classes.isURI(field.getReference().getClassName())) {
                return URI_TRANSFORMER;
            }
            if (Classes.isDuration(field.getReference().getClassName())) {
                return DURATION_TRANSFORMER;
            }
            if (Classes.isPeriod(field.getReference().getClassName())) {
                return PERIOD_TRANSFORMER;
            }
        }
        return null;
    }

    public static Transformer dateTransformer(Field field) {
        if (LegacyDateTransformer.SUPPORTED_TYPES.contains(field.getReference().getClassName())) {
            return new LegacyDateTransformer(field);
        }
        if (Calendar.class.getName().equals(field.getReference().getClassName()) || GregorianCalendar.class.getName().equals(field.getReference().getClassName())) {
            return new CalendarTransformer(field);
        }
        return new DateTransformer(field);
    }

    public IN in(OUT var1) throws Exception;

    public OUT out(IN var1);
}

