/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.json;

import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.InputType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InputFieldsInfo {
    private static final Map<String, Map<String, Field>> inputFieldTransformationMap = new HashMap<String, Map<String, Field>>();
    private static final Map<String, Map<String, Field>> inputFieldAdaptingToMap = new HashMap<String, Map<String, Field>>();
    private static final Map<String, Map<String, Field>> inputFieldAdaptingWithMap = new HashMap<String, Map<String, Field>>();
    private static final Map<String, List<Field>> creatorParameters = new HashMap<String, List<Field>>();

    private InputFieldsInfo() {
    }

    protected static void register(InputType inputType) {
        if (inputType.hasFields()) {
            ArrayList<Field> creatorParameters = new ArrayList<Field>();
            for (Field creatorParameter : inputType.getCreatorParameters()) {
                creatorParameters.add(creatorParameter);
            }
            InputFieldsInfo.creatorParameters.put(inputType.getClassName(), creatorParameters);
            HashMap<String, Field> fieldsThatNeedsTransformation = new HashMap<String, Field>();
            HashMap<String, Field> fieldsThatNeedsAdaptingToScalar = new HashMap<String, Field>();
            HashMap<String, Field> fieldsThatNeedsAdaptingWith = new HashMap<String, Field>();
            Collection fields = inputType.getFields().values();
            for (Field field : fields) {
                if (field.hasTransformation() && !field.getTransformation().isJsonB()) {
                    fieldsThatNeedsTransformation.put(field.getName(), field);
                }
                if (field.isAdaptingWith() && !field.getAdaptWith().isJsonB()) {
                    fieldsThatNeedsAdaptingWith.put(field.getName(), field);
                } else if (field.hasWrapper() && field.getWrapper().isMap()) {
                    fieldsThatNeedsAdaptingWith.put(field.getName(), field);
                }
                if (!field.isAdaptingTo() && !field.getReference().isAdaptingTo()) continue;
                fieldsThatNeedsAdaptingToScalar.putIfAbsent(field.getName(), field);
            }
            if (!fieldsThatNeedsTransformation.isEmpty()) {
                inputFieldTransformationMap.put(inputType.getClassName(), fieldsThatNeedsTransformation);
            }
            if (!fieldsThatNeedsAdaptingToScalar.isEmpty()) {
                inputFieldAdaptingToMap.put(inputType.getClassName(), fieldsThatNeedsAdaptingToScalar);
            }
            if (!fieldsThatNeedsAdaptingWith.isEmpty()) {
                inputFieldAdaptingWithMap.put(inputType.getClassName(), fieldsThatNeedsAdaptingWith);
            }
        }
    }

    public static boolean hasTransformationFields(String className) {
        return inputFieldTransformationMap.containsKey(className);
    }

    public static Map<String, Field> getTransformationFields(String className) {
        if (inputFieldTransformationMap.containsKey(className)) {
            return inputFieldTransformationMap.get(className);
        }
        return null;
    }

    public static boolean hasAdaptToFields(String className) {
        return inputFieldAdaptingToMap.containsKey(className);
    }

    public static Map<String, Field> getAdaptToFields(String className) {
        if (inputFieldAdaptingToMap.containsKey(className)) {
            return inputFieldAdaptingToMap.get(className);
        }
        return null;
    }

    public static boolean hasAdaptWithFields(String className) {
        return inputFieldAdaptingWithMap.containsKey(className);
    }

    public static Map<String, Field> getAdaptWithFields(String className) {
        if (inputFieldAdaptingWithMap.containsKey(className)) {
            return inputFieldAdaptingWithMap.get(className);
        }
        return null;
    }

    public static List<Field> getCreatorParameters(String className) {
        if (creatorParameters.containsKey(className)) {
            return creatorParameters.get(className);
        }
        return Collections.emptyList();
    }
}

