/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.resolver;

import graphql.TypeResolutionEnvironment;
import graphql.schema.GraphQLObjectType;
import graphql.schema.TypeResolver;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.execution.resolver.UnionOutputRegistry;
import io.smallrye.graphql.schema.model.UnionType;

public class UnionResolver
implements TypeResolver {
    private final UnionType unionType;

    public UnionResolver(UnionType unionType) {
        this.unionType = unionType;
    }

    public GraphQLObjectType getType(TypeResolutionEnvironment tre) {
        String concreteClassName = tre.getObject().getClass().getName();
        GraphQLObjectType graphQLObjectType = UnionOutputRegistry.getGraphQLObjectType(this.unionType, concreteClassName);
        if (graphQLObjectType != null) {
            return graphQLObjectType;
        }
        throw SmallRyeGraphQLServerMessages.msg.concreteClassNotFoundForInterface(concreteClassName, this.unionType.getName());
    }
}

