/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.model;

import io.smallrye.graphql.schema.model.DirectiveArgument;
import io.smallrye.graphql.schema.model.Field;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DirectiveType {
    private String className;
    private String name;
    private String description;
    private Set<String> locations = new LinkedHashSet<String>();
    private List<DirectiveArgument> argumentTypes = new ArrayList<DirectiveArgument>();
    private boolean repeatable;

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setLocations(Set<String> locations) {
        this.locations = locations;
    }

    public Set<String> getLocations() {
        return this.locations;
    }

    public List<DirectiveArgument> getArgumentTypes() {
        return this.argumentTypes;
    }

    public void setArgumentTypes(List<DirectiveArgument> argumentTypes) {
        this.argumentTypes = argumentTypes;
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public void setRepeatable(boolean repeatable) {
        this.repeatable = repeatable;
    }

    public Map<String, DirectiveArgument> argumentTypesAsMap() {
        return this.argumentTypes.stream().collect(Collectors.toMap(Field::getName, arg -> arg));
    }

    public Set<String> argumentNames() {
        return this.argumentTypesAsMap().keySet();
    }

    public DirectiveArgument argumentType(String name) {
        return this.argumentTypesAsMap().get(name);
    }

    public void addArgumentType(DirectiveArgument type) {
        this.argumentTypes.add(type);
    }

    public String toString() {
        return "DirectiveType(" + (String)(this.className == null ? "" : "className='" + this.className + "'") + (String)(this.name == null ? "" : ", name='" + this.name + "'") + (String)(this.description == null ? "" : ", description='" + this.description + "'") + (String)(this.locations == null ? "" : ", locations=" + this.locations) + (String)(this.argumentTypes.isEmpty() ? "" : ", argumentTypes=" + this.argumentTypes) + ")";
    }
}

